<?php
/**
 * Plugin Name:           AutomatorWP - Asgaros Forum
 * Plugin URI:            https://automatorwp.com/add-ons/asgaros-forum/
 * Description:           Connect AutomatorWP with Asgaros Forum.
 * Version:               1.0.0
 * Author:                AutomatorWP
 * Author URI:            https://automatorwp.com/
 * Text Domain:           automatorwp-asgaros-forum
 * Domain Path:           /languages/
 * Requires at least:     4.4
 * Tested up to:          6.8
 * License:               GNU AGPL v3.0 (http://www.gnu.org/licenses/agpl.txt)
 *
 * @package               AutomatorWP\AsgarosForum
 * @author                AutomatorWP
 * @copyright             Copyright (c) AutomatorWP
 */

final class AutomatorWP_Asgaros_Forum {

    /**
     * @var         AutomatorWP_Asgaros_Forum $instance The one true AutomatorWP_Asgaros_Forum
     * @since       1.0.0
     */
    private static $instance;

    /**
     * Get active instance
     *
     * @access      public
     * @since       1.0.0
     * @return      AutomatorWP_Asgaros_Forum self::$instance The one true AutomatorWP_Asgaros_Forum
     */
    public static function instance() {
        if( !self::$instance ) {
            self::$instance = new AutomatorWP_Asgaros_Forum();
            self::$instance->constants();
            self::$instance->includes();
            self::$instance->hooks();            
        }

        return self::$instance;
    }

    /**
     * Setup plugin constants
     *
     * @access      private
     * @since       1.0.0
     * @return      void
     */
    private function constants() {
        // Plugin version
        define( 'AUTOMATORWP_ASGAROS_FORUM_VER', '1.0.0' );

        // Plugin file
        define( 'AUTOMATORWP_ASGAROS_FORUM_FILE', __FILE__ );

        // Plugin path
        define( 'AUTOMATORWP_ASGAROS_FORUM_DIR', plugin_dir_path( __FILE__ ) );
        
        // Plugin URL
        define( 'AUTOMATORWP_ASGAROS_FORUM_URL', plugin_dir_url( __FILE__ ) );
    }

    /**
     * Include plugin files
     *
     * @access      private
     * @since       1.0.0
     * @return      void
     */
    private function includes() {

        if( $this->meets_requirements() ) {

            // Includes
            require_once AUTOMATORWP_ASGAROS_FORUM_DIR . 'includes/ajax-functions.php';
            require_once AUTOMATORWP_ASGAROS_FORUM_DIR . 'includes/functions.php';
            require_once AUTOMATORWP_ASGAROS_FORUM_DIR . 'includes/tags.php';

            // Triggers
            require_once AUTOMATORWP_ASGAROS_FORUM_DIR . 'includes/triggers/create-topic.php';
            require_once AUTOMATORWP_ASGAROS_FORUM_DIR . 'includes/triggers/reply-topic.php';
            require_once AUTOMATORWP_ASGAROS_FORUM_DIR . 'includes/triggers/like-post.php';
            require_once AUTOMATORWP_ASGAROS_FORUM_DIR . 'includes/triggers/dislike-post.php';
            require_once AUTOMATORWP_ASGAROS_FORUM_DIR . 'includes/triggers/remove-like-post.php';
            require_once AUTOMATORWP_ASGAROS_FORUM_DIR . 'includes/triggers/remove-dislike-post.php';
            require_once AUTOMATORWP_ASGAROS_FORUM_DIR . 'includes/triggers/get-like-post.php';
            require_once AUTOMATORWP_ASGAROS_FORUM_DIR . 'includes/triggers/get-dislike-post.php';
            
        }
    }

    /**
     * Setup plugin hooks
     *
     * @access      private
     * @since       1.0.0
     * @return      void
     */
    private function hooks() {

        add_action( 'automatorwp_init', array( $this, 'register_integration' ) );
        
        
    }

    /**
     * Registers this integration
     *
     * @since 1.0.0
     */
    function register_integration() {

        automatorwp_register_integration( 'asgaros_forum', array(
            'label' => 'Asgaros Forum',
            'icon'  => AUTOMATORWP_ASGAROS_FORUM_URL . 'assets/asgaros-forum.svg',
        ) );

    }

    /**
     * Check if there are all plugin requirements
     *
     * @since  1.0.0
     *
     * @return bool True if installation meets all requirements
     */
    private function meets_requirements() {

        if ( ! class_exists( 'AutomatorWP' ) ) {
            return false;
        }

        if ( ! class_exists( 'AsgarosForum' ) ) {
            return false;
        }

        return true;

    }

}

/**
 * The main function responsible for returning the one true AutomatorWP_Asgaros_Forum instance to functions everywhere
 *
 * @since       1.0.0
 * @return      \AutomatorWP_Asgaros_Forum The one true AutomatorWP_Asgaros_Forum
 */
function AutomatorWP_Asgaros_Forum() {
    return AutomatorWP_Asgaros_Forum::instance();
}
add_action( 'plugins_loaded', 'AutomatorWP_Asgaros_Forum' );
