<?php
/**
 * Unsubscribe User Forum
 *
 * @package     AutomatorWP\Integrations\bbPress\Actions\Unsubscribe_User_Forum
 * @author      AutomatorWP <contact@automatorwp.com>, Ruben Garcia <rubengcdev@gmail.com>
 * @since       1.0.0
 */
// Exit if accessed directly
if( !defined( 'ABSPATH' ) ) exit;

class AutomatorWP_bbPress_Unsubscribe_User_Forum extends AutomatorWP_Integration_Action {

    public $integration = 'bbpress';
    public $action = 'bbpress_unsubscribe_user_forum';

    /**
     * Register the trigger
     *
     * @since 1.0.0
     */
    public function register() {

        automatorwp_register_action( $this->action, array(
            'integration'       => $this->integration,
            'label'             => __( 'Unsubscribe user from forum', 'automatorwp-pro' ),
            'select_option'     => __( 'Unsubscribe user from <strong>forum</strong>', 'automatorwp-pro' ),
            /* translators: %1$s: User. %2$s: Forum Title. */
            'edit_label'        => sprintf( __( 'Unsubscribe %1$s from %2$s', 'automatorwp-pro' ), '{user}', '{forum}' ),
            /* translators: %1$s: User. %2$s: Forum Title. */
            'log_label'         => sprintf( __( 'Unsubscribe %1$s from %2$s', 'automatorwp-pro' ), '{user}', '{forum}' ),
            'options'           => array(
                'user' => array(
                    'from' => 'user',
                    'default' => __( 'user', 'automatorwp-pro' ),
                    'fields' => array(
                        'user' => array(
                            'name' => __( 'User ID:', 'automatorwp-pro' ),
                            'desc' => __( 'User ID that will get unsubscribed from the forum. Leave blank to unsubscribe the user that completes the automation.', 'automatorwp-pro' ),
                            'type' => 'input',
                            'default' => ''
                        ),
                    )
                ),
                'forum' => array(
                    'from' => 'forum',
                    'fields' => array(
                        'forum' => automatorwp_utilities_post_field( array(
                            'name' => __( 'Forum:', 'automatorwp-pro' ),
                            'option_none_label' => __( 'any forum', 'automatorwp-pro' ),
                            'post_type_cb' => 'bbp_get_forum_post_type'
                        ) )
                    )
                ),
            ),
        ) );

    }

    /**
     * Action execution function
     *
     * @since 1.0.0
     *
     * @param stdClass  $action             The action object
     * @param int       $user_id            The user ID
     * @param array     $action_options     The action's stored options (with tags already passed)
     * @param stdClass  $automation         The action's automation object
     */
    public function execute( $action, $user_id, $action_options, $automation ) {

        // Shorthand
        $forum_id = $action_options['forum'];
        $user_id_to_unsubscribe = absint( $action_options['user'] );

        // Bail if forum not provided
        if( absint( $forum_id ) === 0 ) {
            return;
        }

        if( $user_id_to_unsubscribe === 0 ) {
            $user_id_to_unsubscribe = $user_id;
        }

        // Unsubscribe user to the forum
        bbp_remove_user_forum_subscription( $user_id_to_unsubscribe, $forum_id );

    }

}

new AutomatorWP_bbPress_Unsubscribe_User_Forum();