<?php
/**
 * Add Group Activity
 *
 * @package     AutomatorWP\Integrations\BuddyPress\Actions\Add_Group_Activity
 * @author      AutomatorWP <contact@automatorwp.com>, Ruben Garcia <rubengcdev@gmail.com>
 * @since       1.0.0
 */
// Exit if accessed directly
if( !defined( 'ABSPATH' ) ) exit;

class AutomatorWP_BuddyPress_Add_Group_Activity extends AutomatorWP_Integration_Action {

    public $integration = 'buddypress';
    public $action = 'buddypress_add_group_activity';

    /**
     * Register the trigger
     *
     * @since 1.0.0
     */
    public function register() {

        automatorwp_register_action( $this->action, array(
            'integration'       => $this->integration,
            'label'             => __( 'Add an activity to a group', 'automatorwp-pro' ),
            'select_option'     => __( 'Add an <strong>activity</strong> to a group', 'automatorwp-pro' ),
            /* translators: %1$s: Activity. %2$s: Group. */
            'edit_label'        => sprintf( __( 'Add an %1$s to %2$s', 'automatorwp-pro' ), '{activity}', '{group}' ),
            /* translators: %1$s: Activity. %2$s: Group. */
            'log_label'         => sprintf( __( 'Add an %1$s to %2$s', 'automatorwp-pro' ), '{activity}', '{group}' ),
            'options'           => array(
                'activity' => array(
                    'default' => __( 'activity', 'automatorwp-pro' ),
                    'fields' => array(
                        // Note: "action" key is reserved
                        'activity_action' => array(
                            'name' => __( 'Action:', 'automatorwp-pro' ),
                            'desc' => __( 'Activity\'s action.', 'automatorwp-pro' ),
                            'type' => 'text',
                            'default' => ''
                        ),
                        'author' => array(
                            'name' => __( 'Author:', 'automatorwp-pro' ),
                            'desc' => __( 'The user ID of the activity\'s author. Leave blank to set the user who completed the automation.', 'automatorwp-pro' ),
                            'type' => 'text',
                            'default' => ''
                        ),
                        'content' => array(
                            'name' => __( 'Content:', 'automatorwp-pro' ),
                            'desc' => __( 'Activity\'s content.', 'automatorwp-pro' ),
                            'type' => 'wysiwyg',
                            'default' => ''
                        ),
                        'link' => array(
                            'name' => __( 'Link:', 'automatorwp-pro' ),
                            'desc' => __( 'URL link associated to the activity.', 'automatorwp-pro' ),
                            'type' => 'text',
                            'default' => ''
                        ),
                        'hide_sitewide' => array(
                            'name' => __( 'Hide on the sitewide activity stream:', 'automatorwp' ),
                            'desc' => __( 'Check this option to hide this activity from the sitewide activity stream.', 'automatorwp' ),
                            'type' => 'checkbox',
                            'classes' => 'cmb2-switch'
                        ),
                    )
                ),
                'group' => automatorwp_utilities_ajax_selector_option( array(
                    'field'             => 'group',
                    'option_default'    => __( 'group', 'automatorwp-pro' ),
                    'name'              => __( 'Group:', 'automatorwp-pro' ),
                    'option_none'       => false,
                    'option_custom'         => true,
                    'option_custom_desc'    => __( 'Group ID', 'automatorwp-pro' ),
                    'action_cb'         => 'automatorwp_buddypress_get_groups',
                    'options_cb'        => 'automatorwp_buddypress_options_cb_group',
                    'placeholder'       => __( 'Select a group', 'automatorwp-pro' ),
                    'default'           => '',
                ) )
            ),
        ) );

    }

    /**
     * Action execution function
     *
     * @since 1.0.0
     *
     * @param stdClass  $action             The action object
     * @param int       $user_id            The user ID
     * @param array     $action_options     The action's stored options (with tags already passed)
     * @param stdClass  $automation         The action's automation object
     */
    public function execute( $action, $user_id, $action_options, $automation ) {

        if( ! function_exists( 'bp_activity_add' ) ) {
            return;
        }

        // Shorthand
        $activity_action    = $action_options['activity_action'];
        $author             = $action_options['author'];
        $content            = $action_options['content'];
        $link               = $action_options['link'];
        $group              = $action_options['group'];
        $hide               = $action_options['hide_sitewide'];

        // Setup the author
        if( empty( $author ) ) {
            $author = $user_id;
        }

        if( absint( $author ) === 0 ) {
            return;
        }

        // Check the group
        if( absint( $group ) === 0 ) {
            return;
        }
error_log($group);
        // Add the activity to the user
        bp_activity_add( array(
            'action'            => $activity_action,
            'content'           => $content,
            'component'         => 'groups',
            'type'              => 'activity_update',
            'primary_link'      => $link,
            'user_id'           => $author,
            'item_id'           => $group,
            'secondary_item_id' => false,
            'hide_sitewide'     => (bool) $hide,
        ) );

        /*groups_record_activity( array(
            'action'            => $activity_action,
            'content'           => $content,
            'component'         => buddypress()->groups->id,
            'type'              => 'activity_update',
            'primary_link'      => $link,
            'user_id'           => $author,
            'item_id'           => $group,
            'secondary_item_id' => false,
            'hide_sitewide'     => (bool) $hide,
        ) );*/

    }

}

new AutomatorWP_BuddyPress_Add_Group_Activity();