<?php
/**
 * Plugin Name:           AutomatorWP - CSV
 * Plugin URI:            https://automatorwp.com/add-ons/csv/
 * Description:           Connect AutomatorWP with CSV.
 * Version:               1.0.2
 * Author:                AutomatorWP
 * Author URI:            https://automatorwp.com/
 * Text Domain:           automatorwp-csv
 * Domain Path:           /languages/
 * Requires at least:     4.4
 * Tested up to:          6.7
 * License:               GNU AGPL v3.0 (http://www.gnu.org/licenses/agpl.txt)
 *
 * @package               AutomatorWP\CSV
 * @author                AutomatorWP
 * @copyright             Copyright (c) AutomatorWP
 */

final class AutomatorWP_CSV {

    /**
     * @var         AutomatorWP_CSV $instance The one true AutomatorWP_CSV
     * @since       1.0.0
     */
    private static $instance;

    /**
     * Get active instance
     *
     * @access      public
     * @since       1.0.0
     * @return      AutomatorWP_CSV self::$instance The one true AutomatorWP_CSV
     */
    public static function instance() {
        if( !self::$instance ) {
            self::$instance = new AutomatorWP_CSV();
            self::$instance->constants();
            self::$instance->includes();
            self::$instance->hooks();        }

        return self::$instance;
    }

    /**
     * Setup plugin constants
     *
     * @access      private
     * @since       1.0.0
     * @return      void
     */
    private function constants() {
        // Plugin version
        define( 'AUTOMATORWP_CSV_VER', '1.0.2' );

        // Plugin file
        define( 'AUTOMATORWP_CSV_FILE', __FILE__ );

        // Plugin path
        define( 'AUTOMATORWP_CSV_DIR', plugin_dir_path( __FILE__ ) );

        // Plugin URL
        define( 'AUTOMATORWP_CSV_URL', plugin_dir_url( __FILE__ ) );
    }

    /**
     * Include plugin files
     *
     * @access      private
     * @since       1.0.0
     * @return      void
     */
    private function includes() {

        if( $this->meets_requirements() ) {

            // Includes
            require_once AUTOMATORWP_CSV_DIR . 'includes/functions.php';
            require_once AUTOMATORWP_CSV_DIR . 'includes/scripts.php';
            require_once AUTOMATORWP_CSV_DIR . 'includes/tags.php';

        }
    }

    /**
     * Setup plugin hooks
     *
     * @access      private
     * @since       1.0.0
     * @return      void
     */
    private function hooks() {

        add_action( 'automatorwp_init', array( $this, 'register_integration' ) );
        
        

        
    }

    /**
     * Registers this integration
     *
     * @since 1.0.0
     */
    function register_integration() {

        automatorwp_register_integration( 'csv', array(
            'label' => 'CSV',
            'icon'  => AUTOMATORWP_CSV_URL . 'assets/img/csv.svg',
        ) );

        // Automations
        require_once AUTOMATORWP_CSV_DIR . 'includes/automations/import-file.php';

        // Triggers
        require_once AUTOMATORWP_CSV_DIR . 'includes/triggers/import-csv.php';

    }

    /**
     * Check if there are all plugin requirements
     *
     * @since  1.0.0
     *
     * @return bool True if installation meets all requirements
     */
    private function meets_requirements() {

        if ( ! class_exists( 'AutomatorWP' ) ) {
            return false;
        }

        return true;

    }

}

/**
 * The main function responsible for returning the one true AutomatorWP_CSV instance to functions everywhere
 *
 * @since       1.0.0
 * @return      \AutomatorWP_CSV The one true AutomatorWP_CSV
 */
function AutomatorWP_CSV() {
    return AutomatorWP_CSV::instance();
}
add_action( 'plugins_loaded', 'AutomatorWP_CSV' );
