<?php
/**
 * Ajax Functions
 *
 * @package     AutomatorWP\Custom_User_Fields\Ajax_Function
 * @author      AutomatorWP <contact@automatorwp.com>, Ruben Garcia <rubengcdev@gmail.com>
 * @since       1.0.0
 */
// Exit if accessed directly
if( !defined( 'ABSPATH' ) ) exit;

/**
 * Ajax function for selecting contents
 *
 * @since 1.0.0
 */
function automatorwp_custom_user_fields_ajax_get_fields() {
    // Security check, forces to die if not security passed
    check_ajax_referer( 'automatorwp_admin', 'nonce' );

    global $wpdb;

    // Pull back the search string
    $search = isset( $_REQUEST['q'] ) ? $wpdb->esc_like( sanitize_text_field( $_REQUEST['q'] ) ) : '';

    $custom_fields = automatorwp_custom_user_fields_get_fields();
    
    $results = array();

    // Parse lists results to match select2 results
    foreach ( $custom_fields as $field ) {

        if( ! empty( $search ) ) {
            if( strpos( strtolower( $field['name'] ), strtolower( $search ) ) === false ) {
                continue;
            }
        }

        $results[] = array(
            'id'   => $field['id'],
            'text' => $field['name']
        );
    }

    // Prepend option none
    $results = automatorwp_ajax_get_ajax_results_option_none( $results );

    // Return our results
    wp_send_json_success( $results );
    die;

}
add_action( 'wp_ajax_automatorwp_custom_user_fields_get_fields', 'automatorwp_custom_user_fields_ajax_get_fields' );