<?php
/**
 * Users
 *
 * @package     AutomatorWP\Custom User Fields\Users
 * @since       1.0.0
 */
// Exit if accessed directly
if( !defined( 'ABSPATH' ) ) exit;

/**
 * Display achievements for a user on their profile screen
 *
 * @since  1.0.0
 * @param  object $user The current user's $user object
 * @return void
 */
function automatorwp_custom_user_fields_user_profile_data( $user = null ) {

    $custom_field_fields = automatorwp_custom_user_fields_get_all();

    if( count( $custom_field_fields ) === 0 ) {
        return;
    }

    if( ! current_user_can( automatorwp_get_manager_capability() ) ) {
        return;
    }
    ?>

    <hr>

    <h2><?php echo automatorwp_dashicon( 'automatorwp' ); ?> <?php _e( 'Custom User Fields', 'automatorwp-pro' ); ?></h2>


    <?php

    automatorwp_custom_user_fields_user_meta_box( $user );

}
add_action( 'show_user_profile', 'automatorwp_custom_user_fields_user_profile_data' );
add_action( 'edit_user_profile', 'automatorwp_custom_user_fields_user_profile_data' );

function automatorwp_custom_user_fields_user_meta_box( $user = null ) {

    $custom_field_fields = automatorwp_custom_user_fields_get_all();

    // Setup the CMB2 form
    $cmb2 = new CMB2( array(
        'id'        => 'automatorwp_custom_user_fields_form',
        'object_types' => array( 'user' ),
        'classes'   => 'automatorwp-form automatorwp-custom-user-field-form',
        'hookup'    => false,
    ), $user->ID );

    $fields_array = array();

    // Setup the options fields
    foreach ( $custom_field_fields as $field_id => $field ) {

        // Add the field to the form
        $cmb2->add_field( array(
                'id' => $field->meta_key,
                'name' => $field->name,
                'type' => 'text',
        ) );

    }

    // Render the form
    CMB2_Hookup::enqueue_cmb_css();
    CMB2_Hookup::enqueue_cmb_js();
    $cmb2->show_form();

    ?>

    <?php
}

/**
 * Process the adding/revoking of achievements on the user profile page
 *
 * @since  1.0.0
 */
function automatorwp_custom_user_fields_save_user_data( $user_id ) {

    if ( empty( $_POST['_wpnonce'] ) || ! wp_verify_nonce( $_POST['_wpnonce'], 'update-user_' . $user_id ) ) {
        return;
    }

    // verify user meets minimum role to view earned achievements
    if ( current_user_can( automatorwp_get_manager_capability() ) ) {

        $custom_field_fields = automatorwp_custom_user_fields_get_all();

        foreach ( $custom_field_fields as $field_id => $field ) {

            $meta_key = sanitize_key( $field->meta_key );
            $meta_value = sanitize_text_field( $_POST[$meta_key] );

            // Save the user meta
            update_user_meta( $user_id, $meta_key, $meta_value);

        }

    }

}
add_action( 'personal_options_update', 'automatorwp_custom_user_fields_save_user_data' );
add_action( 'edit_user_profile_update', 'automatorwp_custom_user_fields_save_user_data' );