<?php
/**
 * Plugin Name:           AutomatorWP - Divi
 * Plugin URI:            https://automatorwp.com/add-ons/divi/
 * Description:           Connect AutomatorWP with Divi.
 * Version:               1.0.1
 * Author:                AutomatorWP
 * Author URI:            https://automatorwp.com/
 * Text Domain:           automatorwp-divi
 * Domain Path:           /languages/
 * Requires at least:     4.4
 * Tested up to:          6.4
 * License:               GNU AGPL v3.0 (http://www.gnu.org/licenses/agpl.txt)
 *
 * @package               AutomatorWP\Divi
 * @author                AutomatorWP
 * @copyright             Copyright (c) AutomatorWP
 */

final class AutomatorWP_Divi {

    /**
     * @var         AutomatorWP_Divi $instance The one true AutomatorWP_Divi
     * @since       1.0.0
     */
    private static $instance;

    /**
     * Get active instance
     *
     * @access      public
     * @since       1.0.0
     * @return      AutomatorWP_Divi self::$instance The one true AutomatorWP_Divi
     */
    public static function instance() {
        if( !self::$instance ) {
            self::$instance = new AutomatorWP_Divi();
            self::$instance->constants();
            self::$instance->includes();
            self::$instance->hooks();            
        }

        return self::$instance;
    }

    /**
     * Setup plugin constants
     *
     * @access      private
     * @since       1.0.0
     * @return      void
     */
    private function constants() {
        // Plugin version
        define( 'AUTOMATORWP_DIVI_VER', '1.0.1' );

        // Plugin file
        define( 'AUTOMATORWP_DIVI_FILE', __FILE__ );

        // Plugin path
        define( 'AUTOMATORWP_DIVI_DIR', plugin_dir_path( __FILE__ ) );

        // Plugin URL
        define( 'AUTOMATORWP_DIVI_URL', plugin_dir_url( __FILE__ ) );
    }

    /**
     * Include plugin files
     *
     * @access      private
     * @since       1.0.0
     * @return      void
     */
    private function includes() {

        if( $this->meets_requirements() ) {

            // Includes
            require_once AUTOMATORWP_DIVI_DIR . 'includes/functions.php';

            // Triggers
            require_once AUTOMATORWP_DIVI_DIR . 'includes/triggers/submit-form.php';
            require_once AUTOMATORWP_DIVI_DIR . 'includes/triggers/submit-field-value.php';
            // Anonymous Triggers
            require_once AUTOMATORWP_DIVI_DIR . 'includes/triggers/anonymous-submit-form.php';
            require_once AUTOMATORWP_DIVI_DIR . 'includes/triggers/anonymous-submit-field-value.php';


        }
    }

    /**
     * Setup plugin hooks
     *
     * @access      private
     * @since       1.0.0
     * @return      void
     */
    private function hooks() {

        add_action( 'automatorwp_init', array( $this, 'register_integration' ) );
        
        

        
    }

    /**
     * Registers this integration
     *
     * @since 1.0.0
     */
    function register_integration() {

        automatorwp_register_integration( 'divi', array(
            'label' => 'Divi',
            'icon'  => AUTOMATORWP_DIVI_URL . 'assets/divi.svg',
        ) );

    }

    /**
     * Check if there are all plugin requirements
     *
     * @since  1.0.0
     *
     * @return bool True if installation meets all requirements
     */
    private function meets_requirements() {

        if ( ! class_exists( 'AutomatorWP' ) ) {
            return false;
        }

        $theme = wp_get_theme();

        if ( $theme->get_template() !== 'Divi' ) {
            return false;
        }

        return true;

    }

}

/**
 * The main function responsible for returning the one true AutomatorWP_Divi instance to functions everywhere
 *
 * @since       1.0.0
 * @return      \AutomatorWP_Divi The one true AutomatorWP_Divi
 */
function AutomatorWP_Divi() {
    return AutomatorWP_Divi::instance();
}
add_action( 'plugins_loaded', 'AutomatorWP_Divi' );
