<?php
/**
 * Functions
 *
 * @package     AutomatorWP\Fluent_Support\Functions
 * @since       1.0.0
 */
// Exit if accessed directly
if( !defined( 'ABSPATH' ) ) exit;

/**
 * Get products
 *
 * @since 1.0.0
 * 
 * @param stdClass $field
 *
 * @return array
 */
function automatorwp_fluent_support_options_cb_product( $field ) {

        // Setup vars
        $value = $field->escaped_value;
        $none_value = 'any';
        $none_label = __( 'any product', 'automatorwp-pro' );
        $options = automatorwp_options_cb_none_option( $field, $none_value, $none_label );
        
        if( ! empty( $value ) ) {
            if( ! is_array( $value ) ) {
                $value = array( $value );
            }
    
            foreach( $value as $product_id ) {
    
                // Skip option none
                if( $product_id === $none_value ) {
                    continue;
                }
                
                $options[$product_id] = automatorwp_fluent_support_get_product_name( $product_id );
            }
        }
    
        return $options;

}

/**
 * Get products
 *
 * @since 1.0.0
 *
 * @return array
 */
function automatorwp_fluent_support_get_products( ) {

    $products = array();

    // Get all products
    $all_products = json_decode( \FluentSupport\App\Models\Product::select( array( 'id', 'title' ) )->get(), true );

    foreach ( $all_products as $product ) {

        $products[] = array(
            'id' => $product['id'],
            'name' => $product['title'],
        );

    }

    return $products;

}

/**
 * Get product name
 *
 * @since 1.0.0
 *
 * @param int   $product_id ID product
 * 
 */
function automatorwp_fluent_support_get_product_name( $product_id ) {

    // Bail if no product
    if ( empty( $product_id ) ) {
        return false;
    }


    $obj_product = new \FluentSupport\App\Models\Product;
    $product = $obj_product->getProduct( $product_id );
    
    return $product['product']->title;

}