<?php
/**
 * Plugin Name:           AutomatorWP - FluentCRM
 * Plugin URI:            https://automatorwp.com/add-ons/fluentcrm/
 * Description:           Connect AutomatorWP with FluentCRM.
 * Version:               1.1.2
 * Author:                AutomatorWP
 * Author URI:            https://automatorwp.com/
 * Text Domain:           automatorwp-fluentcrm
 * Domain Path:           /languages/
 * Requires at least:     4.4
 * Tested up to:          6.6
 * License:               GNU AGPL v3.0 (http://www.gnu.org/licenses/agpl.txt)
 *
 * @package               AutomatorWP\FluentCRM
 * @author                AutomatorWP
 * @copyright             Copyright (c) AutomatorWP
 */

final class AutomatorWP_FluentCRM {

    /**
     * @var         AutomatorWP_FluentCRM $instance The one true AutomatorWP_FluentCRM
     * @since       1.0.0
     */
    private static $instance;

    /**
     * Get active instance
     *
     * @access      public
     * @since       1.0.0
     * @return      AutomatorWP_FluentCRM self::$instance The one true AutomatorWP_FluentCRM
     */
    public static function instance() {
        if( !self::$instance ) {
            self::$instance = new AutomatorWP_FluentCRM();
            self::$instance->constants();
            self::$instance->includes();
            self::$instance->hooks();            
        }

        return self::$instance;
    }

    /**
     * Setup plugin constants
     *
     * @access      private
     * @since       1.0.0
     * @return      void
     */
    private function constants() {
        // Plugin version
        define( 'AUTOMATORWP_FLUENTCRM_VER', '1.1.2' );

        // Plugin file
        define( 'AUTOMATORWP_FLUENTCRM_FILE', __FILE__ );

        // Plugin path
        define( 'AUTOMATORWP_FLUENTCRM_DIR', plugin_dir_path( __FILE__ ) );

        // Plugin URL
        define( 'AUTOMATORWP_FLUENTCRM_URL', plugin_dir_url( __FILE__ ) );
    }

    /**
     * Include plugin files
     *
     * @access      private
     * @since       1.0.0
     * @return      void
     */
    private function includes() {

        if( $this->meets_requirements() ) {

            // Includes
            require_once AUTOMATORWP_FLUENTCRM_DIR . 'includes/ajax-functions.php';
            require_once AUTOMATORWP_FLUENTCRM_DIR . 'includes/functions.php';
            require_once AUTOMATORWP_FLUENTCRM_DIR . 'includes/tags.php';

            // Triggers
            require_once AUTOMATORWP_FLUENTCRM_DIR . 'includes/triggers/tag-added.php';
            require_once AUTOMATORWP_FLUENTCRM_DIR . 'includes/triggers/tag-removed.php';
            require_once AUTOMATORWP_FLUENTCRM_DIR . 'includes/triggers/list-added.php';
            require_once AUTOMATORWP_FLUENTCRM_DIR . 'includes/triggers/list-removed.php';
            require_once AUTOMATORWP_FLUENTCRM_DIR . 'includes/triggers/status-change.php';

            // Anonymous Triggers
            require_once AUTOMATORWP_FLUENTCRM_DIR . 'includes/triggers/anonymous-tag-added.php';
            require_once AUTOMATORWP_FLUENTCRM_DIR . 'includes/triggers/anonymous-tag-removed.php';
            require_once AUTOMATORWP_FLUENTCRM_DIR . 'includes/triggers/anonymous-list-added.php';
            require_once AUTOMATORWP_FLUENTCRM_DIR . 'includes/triggers/anonymous-list-removed.php';
            require_once AUTOMATORWP_FLUENTCRM_DIR . 'includes/triggers/anonymous-status-change.php';

            // Actions
            require_once AUTOMATORWP_FLUENTCRM_DIR . 'includes/actions/create-contact.php';
            require_once AUTOMATORWP_FLUENTCRM_DIR . 'includes/actions/user-tag.php';
            require_once AUTOMATORWP_FLUENTCRM_DIR . 'includes/actions/user-list.php';
            require_once AUTOMATORWP_FLUENTCRM_DIR . 'includes/actions/contact-tag.php';
            require_once AUTOMATORWP_FLUENTCRM_DIR . 'includes/actions/create-contact-tag.php';
            require_once AUTOMATORWP_FLUENTCRM_DIR . 'includes/actions/contact-list.php';
            require_once AUTOMATORWP_FLUENTCRM_DIR . 'includes/actions/change-status.php';

            // Filters
            require_once AUTOMATORWP_FLUENTCRM_DIR . 'includes/filters/user-has-tag.php';
            require_once AUTOMATORWP_FLUENTCRM_DIR . 'includes/filters/user-has-not-tag.php';
            require_once AUTOMATORWP_FLUENTCRM_DIR . 'includes/filters/user-is-added-list.php';
            require_once AUTOMATORWP_FLUENTCRM_DIR . 'includes/filters/user-is-not-added-list.php';

        }
    }

    /**
     * Setup plugin hooks
     *
     * @access      private
     * @since       1.0.0
     * @return      void
     */
    private function hooks() {

        add_action( 'automatorwp_init', array( $this, 'register_integration' ) );
        
        

        
    }

    /**
     * Registers this integration
     *
     * @since 1.0.0
     */
    function register_integration() {

        automatorwp_register_integration( 'fluentcrm', array(
            'label' => 'FluentCRM',
            'icon'  => AUTOMATORWP_FLUENTCRM_URL . 'assets/fluentcrm.svg',
        ) );

    }

    /**
     * Check if there are all plugin requirements
     *
     * @since  1.0.0
     *
     * @return bool True if installation meets all requirements
     */
    private function meets_requirements() {

        if ( ! class_exists( 'AutomatorWP' ) ) {
            return false;
        }

        if ( ! defined( 'FLUENTCRM' ) ) {
            return false;
        }

        return true;

    }

}

/**
 * The main function responsible for returning the one true AutomatorWP_FluentCRM instance to functions everywhere
 *
 * @since       1.0.0
 * @return      \AutomatorWP_FluentCRM The one true AutomatorWP_FluentCRM
 */
function AutomatorWP_FluentCRM() {
    return AutomatorWP_FluentCRM::instance();
}
add_action( 'plugins_loaded', 'AutomatorWP_FluentCRM' );
