<?php
/**
 * User Tag
 *
 * @package     AutomatorWP\Integrations\iMember360\Actions\User_Tag
 * @author      AutomatorWP <contact@automatorwp.com>, Ruben Garcia <rubengcdev@gmail.com>
 * @since       1.0.0
 */
// Exit if accessed directly
if( !defined( 'ABSPATH' ) ) exit;

class AutomatorWP_iMember360_User_Tag extends AutomatorWP_Integration_Action {

    public $integration = 'imember360';
    public $action = 'imember360_user_tag';

    /**
     * Register the trigger
     *
     * @since 1.0.0
     */
    public function register() {

        automatorwp_register_action( $this->action, array(
            'integration'       => $this->integration,
            'label'             => __( 'Add or remove tag to user', 'automatorwp-pro' ),
            'select_option'     => __( 'Add or remove <strong>tag</strong> to user', 'automatorwp-pro' ),
            /* translators: %1$s: Operation (add or remove). %2$s: Tag name. */
            'edit_label'        => sprintf( __( '%1$s %2$s to user', 'automatorwp-pro' ), '{operation}', '{tag}' ),
            /* translators: %1$s: Operation (add or remove). %2$s: Tag name. */
            'log_label'         => sprintf( __( '%1$s %2$s to user', 'automatorwp-pro' ), '{operation}', '{tag}' ),
            'options'           => array(
                'operation' => array(
                    'from' => 'operation',
                    'fields' => array(
                        'operation' => array(
                            'name' => __( 'Operation:', 'automatorwp-pro' ),
                            'type' => 'select',
                            'options' => array(
                                'add'       => __( 'Add', 'automatorwp-pro' ),
                                'remove'    => __( 'Remove', 'automatorwp-pro' ),
                            ),
                            'default' => 'add'
                        ),
                    )
                ),
                'tag' => array(
                    'from' => 'tag',
                    'fields' => array(
                        'tag' => array(
                            'name' => __( 'Tag:', 'automatorwp-pro' ),
                            'type' => 'select',
                            'classes' => 'automatorwp-selector',
                            'options_cb' => array( $this, 'tags_options_cb' ),
                            'default' => 'any'
                        )
                    )
                ),
            ),
        ) );

    }

    /**
     * Get tags options
     *
     * @since 1.0.0
     *
     * @return array
     */
    public function tags_options_cb() {

        global $I4WSITE;

        $options = array(
            'any' => __( 'all tags', 'automatorwp-pro' ),
        );

        // Get site tags
        $tags = $I4WSITE['allGROUPS'];

        if( ! empty( $tags ) ) {
            foreach( $tags as $tag_id => $tag_name ) {
                $options[$tag_id] = $tag_name;
            }
        }

        return $options;

    }

    /**
     * Action execution function
     *
     * @since 1.0.0
     *
     * @param stdClass  $action             The action object
     * @param int       $user_id            The user ID
     * @param array     $action_options     The action's stored options (with tags already passed)
     * @param stdClass  $automation         The action's automation object
     */
    public function execute( $action, $user_id, $action_options, $automation ) {

        global $SESSION, $I4WSITE;

        // Shorthand
        $operation = $action_options['operation'];
        $tag_id = $action_options['tag'];

        // Ensure operation default value
        if( empty( $operation ) ) {
            $operation = 'add';
        }

        // Get the user contact ID
        $remote_logged_in = $SESSION['DBSHORT']['id'];

        IF ( empty( $remote_logged_in ) ) {
            $remote_logged_in = get_user_meta( $user_id, 'imember360_user_id', true );
        }

        // Bail if can't get the contact ID
        IF ( empty( $remote_logged_in ) ) {
            return;
        }

        $tags = array();

        // Check specific tag
        if( $tag_id !== 'any' ) {

            $tags = array( $tag_id );

        } else if( $tag_id === 'any' ) {

            // Get all tags

            $all_tags = $I4WSITE['allGROUPS'];

            if( ! empty( $all_tags ) ) {
                $tags = array_keys( $all_tags );
            }
        }

        // Normalize tags
        $tags = array_unique( array_filter( array_map( 'intval', $tags ) ) );

        switch ( $operation ) {
            case 'add':

                // Add tags to the user
                foreach ( $tags AS $tag_id ) {
                    $GLOBALS['i4w']->myApp->grpAssign( $remote_logged_in, absint( $tag_id ) );
                }

                break;
            case 'remove':

                // Remove tags to the user
                foreach ( $tags AS $tag_id ) {
                    $GLOBALS['i4w']->myApp->grpRemove( $remote_logged_in, absint( $tag_id ) );
                }

                break;
        }

    }

}

new AutomatorWP_iMember360_User_Tag();