<?php
/**
 * Publish Post
 *
 * @package     AutomatorWP\Integrations\Instagram\Actions\Publish_Post
 * @author      AutomatorWP
 * @since       1.0.0
 */

// Exit if accessed directly
if (!defined('ABSPATH')) exit;

class AutomatorWP_Instagram_Publish_Post extends AutomatorWP_Integration_Action {

    public $integration = 'instagram';
    public $action = 'instagram_publish';

    public function register() {
        automatorwp_register_action($this->action, array(
            'integration'       => $this->integration,
            'label'             => __('Publish a new post', 'automatorwp-pro'),
            'select_option'     => __('Publish a new <strong>post</strong>', 'automatorwp-pro'),
            'edit_label'        => sprintf( __( 'Create a new %1$s', 'automatorwp-pro' ) , '{post}' ),
            'log_label'         => sprintf( __( 'Create a new %1$s', 'automatorwp-pro' ) , '{post}'),
            'options'           => array(
                'post' => array(
                    'from' => 'post',
                    'default' => __('Instagram Post', 'automatorwp-pro'),
                    'fields' => array(
                        'image_url' => array(
                            'name' => __( 'Image:', 'automatorwp-csv' ),
                            'desc' => __( 'The image to publish. Make sure the image is in the format accepted by Instagram (1:1, 4:5, 1.91:1 or 3:4)', 'automatorwp-pro' ),
							'ajax' => true,
                            'type' => 'file',
                            'query_args' => array(
                                'type' => array(
                                 	'image/gif',
                                 	'image/jpeg',
                                 	'image/png',
                                 ),
                            ),
                            'classes' => 'automatorwp-hide-preview',
                            'required' => true,
                            'default' => ''
                        ),
                        'caption' => array(
                            'name'          => __('Post caption:', 'automatorwp-pro'),
                            'type'          => 'textarea',
                            'required'      => false,
                        ),
                    ),
                )
            ),
        ));
    }

    public function execute( $action, $user_id, $action_options, $automation ) {

        if ( empty( $action_options['image_url'] ) ) {           
            return;
        }
    
        // Shorthand
        $image_url = $action_options['image_url'];
        $caption = isset ($action_options['caption'] ) ? $action_options['caption'] : '';
		$this->result = '';
    
        $response_container = automatorwp_instagram_create_container( $image_url, $caption );
		
		if ( isset ( $response_container['error'] ) ) {
			$this->result = sprintf( __( '%s', 'automatorwp-pro'), $response_container['error']['message'] );
			return;
		}
       
        $response = automatorwp_instagram_publish_post( $response_container['id'] );
		
        if ( !isset ( $response_container['error'] ) ) {
			$this->result = __( 'Photo published on Instagram', 'automatorwp-pro');
			return;
		}
       
    }

    /**
     * Register required hooks
     *
     * @since 1.0.0
     */
    public function hooks() {

        // Configuration notice
       // add_filter( 'automatorwp_automation_ui_after_item_label', array( $this, 'configuration_notice' ), 10, 2 );

        // Log meta data
        add_filter( 'automatorwp_user_completed_action_log_meta', array( $this, 'log_meta' ), 10, 5 );

        // Log fields
        add_filter( 'automatorwp_log_fields', array( $this, 'log_fields' ), 10, 5 );

        parent::hooks();

    }

    /**
     * Configuration notice
     *
     * @since 1.0.0
     *
     * @param stdClass  $object     The trigger/action object
     * @param string    $item_type  The object type (trigger|action)
     */
    public function configuration_notice( $object, $item_type ) {

        // Bail if action type don't match this action
        if( $item_type !== 'action' ) {
            return;
        }

        if( $object->type !== $this->action ) {
            return;
        }

        // Warn user if the authorization has not been setup from settings
        if( ! automatorwp_instagram_get_api() ) : ?>
            <div class="automatorwp-notice-warning" style="margin-top: 10px; margin-bottom: 0;">
                <?php echo sprintf(
                    __( 'You need to configure the <a href="%s" target="_blank">Instagram settings</a> to get this action to work.', 'automatorwp-pro' ),
                    get_admin_url() . 'admin.php?page=automatorwp_settings&tab=opt-tab-instagram'
                ); ?>
                <?php echo sprintf(
                    __( '<a href="%s" target="_blank">Documentation</a>', 'automatorwp-pro' ),
                    'https://automatorwp.com/docs/instagram/'
                ); ?>
            </div>
        <?php endif;
    }

    /**
     * Action custom log meta
     *
     * @since 1.0.0
     *
     * @param array     $log_meta           Log meta data
     * @param stdClass  $action             The action object
     * @param int       $user_id            The user ID
     * @param array     $action_options     The action's stored options (with tags already passed)
     * @param stdClass  $automation         The action's automation object
     *
     * @return array
     */
    public function log_meta( $log_meta, $action, $user_id, $action_options, $automation ) {

        // Bail if action type don't match this action
        if( $action->type !== $this->action ) {
            return $log_meta;
        }

        // Store the action's result
        $log_meta['result'] = $this->result;

        return $log_meta;
    }

    /**
     * Action custom log fields
     *
     * @since 1.0.0
     *
     * @param array     $log_fields The log fields
     * @param stdClass  $log        The log object
     * @param stdClass  $object     The trigger/action/automation object attached to the log
     *
     * @return array
     */
    public function log_fields( $log_fields, $log, $object ) {

        // Bail if log is not assigned to an action
        if( $log->type !== 'action' ) {
            return $log_fields;
        }

        // Bail if action type don't match this action
        if( $object->type !== $this->action ) {
            return $log_fields;
        }

        $log_fields['result'] = array(
            'name' => __( 'Result:', 'automatorwp-pro' ),
            'type' => 'text',
        );

        return $log_fields;
    }
}
new AutomatorWP_Instagram_Publish_Post();