<?php
/**
 * Admin
 *
 * @package     AutomatorWP\Integrations\Instagram\Admin
 * @author      AutomatorWP <contact@automatorwp.com>, Ruben Garcia <rubengcdev@gmail.com>
 * @since       1.0.0
 */
// Exit if accessed directly
if( !defined( 'ABSPATH' ) ) exit;

/**
 * Shortcut function to get plugin options
 *
 * @since  1.0.0
 *
 * @param string    $option_name
 * @param bool      $default
 *
 * @return mixed
 */
function automatorwp_instagram_get_option( $option_name, $default = false ) {

    $prefix = 'automatorwp_instagram_';

    return automatorwp_get_option( $prefix . $option_name, $default );
}

/**
 * Register plugin settings sections
 *
 * @since  1.0.0
 *
 * @return array
 */
function automatorwp_instagram_settings_sections( $automatorwp_settings_sections ) {

    $automatorwp_settings_sections['instagram'] = array(
        'title' => __( 'Instagram', 'automatorwp-pro' ),
        'icon' => 'dashicons-instagram',
    );

    return $automatorwp_settings_sections;

}
add_filter( 'automatorwp_settings_sections', 'automatorwp_instagram_settings_sections' );

/**
 * Register plugin settings meta boxes
 *
 * @since  1.0.0
 *
 * @return array
 */
function automatorwp_instagram_settings_meta_boxes( $meta_boxes )  {

    $prefix = 'automatorwp_instagram_';

    $meta_boxes['automatorwp-instagram-settings'] = array(
        'title' => automatorwp_dashicon( 'instagram' ) . __( 'Instagram', 'automatorwp-pro' ),
        'fields' => apply_filters( 'automatorwp_instagram_settings_fields', array(
            $prefix . 'client_id' => array(
                'name' => __( 'Client ID:', 'automatorwp-pro' ),
                'desc' => __( 'Your Instagram API client ID.', 'automatorwp-pro' ),
                'type' => 'text',
            ),
            $prefix . 'client_secret' => array(
                'name' => __( 'Client Secret:', 'automatorwp-pro' ),
                'desc' => __( 'Your Instagram API client secret.', 'automatorwp-pro' ),
                'type' => 'text',
            ),
            $prefix . 'ig_id' => array(
                'name' => __( 'Instagram ID:', 'automatorwp-pro' ),
                'desc' => __( 'Your Instagram ID client secret.', 'automatorwp-pro' ),
                'type' => 'text',
            ),
            $prefix . 'redirect_url' => array(
                'type' => 'text',
                'render_row_cb' => 'automatorwp_instagram_redirect_url_display_cb',
            ),
            $prefix . 'authorize' => array(
                'type' => 'text',
                'render_row_cb' => 'automatorwp_instagram_authorize_display_cb',
            ),
        ) ),
    );

    return $meta_boxes;

}
add_filter( "automatorwp_settings_instagram_meta_boxes", 'automatorwp_instagram_settings_meta_boxes' );

/**
 * Display callback for the authorize setting
 *
 * @since  1.0.0
 *
 * @param array      $field_args Array of field arguments.
 * @param CMB2_Field $field      The field object
 */
function automatorwp_instagram_redirect_url_display_cb( $field_args, $field ) {
    $admin_url = admin_url('admin.php');

    ?>
    <div class="cmb-row cmb-type-custom cmb2-id-automatorwp-instagram-redirect-url table-layout" data-fieldtype="custom">
        <div class="cmb-th">
            <label><?php echo __( 'Redirect URL:', 'automatorwp-pro' ); ?></label>
        </div>
        <div class="cmb-td">
            <input type="text" class="regular-text" value="<?php echo $admin_url; ?>" readonly>
            <p class="cmb2-metabox-description"><?php echo __( 'Copy this URL and place it the authorized redirect URIs field.', 'automatorwp-pro' ); ?></p>
        </div>
    </div>
    <?php
}

/**
 * Display callback for the authorize setting
 *
 * @since  1.0.0
 *
 * @param array      $field_args Array of field arguments.
 * @param CMB2_Field $field      The field object
 */
function automatorwp_instagram_authorize_display_cb( $field_args, $field ) {

    $field_id = $field_args['id'];
    
    $client_id = automatorwp_instagram_get_option( 'client_id', '' );
    $client_secret = automatorwp_instagram_get_option( 'client_secret', '' );
    $ig_id = automatorwp_instagram_get_option( 'ig_id', '' );
    $auth = get_option( 'automatorwp_instagram_auth' );

    ?>
    <div class="cmb-row cmb-type-custom cmb2-id-automatorwp-instagram-authorize table-layout" data-fieldtype="custom">
        <div class="cmb-th">
            <label><?php echo __( 'Connect with Instagram:', 'automatorwp-pro' ); ?></label>
        </div>
        <div class="cmb-td">
            <a id="<?php echo $field_id; ?>" class="button button-primary" href="#"><?php echo __( 'Authorize', 'automatorwp-pro' ); ?></a>
            <p class="cmb2-metabox-description"><?php echo __( 'Add you Instagram API client ID and secret fields and click on "Authorize" button to generate access keys for this site.', 'automatorwp-pro' ); ?></p>
            <?php if ( is_array( $auth ) ) : ?>
                <div class="automatorwp-notice-success"><?php echo __( 'Site connected with Instagram successfully.', 'automatorwp-pro' ); ?></div>
                <p class="automatorwp-instagram-access-token"><strong><?php echo __( 'Access token:', 'automatorwp-pro' ); ?></strong> <input type="text" value="<?php echo $auth['access_token']; ?>" readonly></p>
               
            <?php elseif( ! empty( $client_id ) && ! empty( $client_secret ) && ! empty( $ig_id ) ) : ?>
                <div class="automatorwp-notice-error"><?php echo __( 'Site not connected with Instagram.', 'automatorwp-pro' ); ?></div>
            <?php endif; ?>
        </div>
    </div>
    <?php
}

/**
 * Check if authorization process has been completed
 *
 * @since  1.0.0
 */
function automatorwp_instagram_maybe_authorize_complete() {


    if( isset( $_GET['code'] ) ) {

        $client_id = automatorwp_instagram_get_option( 'client_id', '' );
        $client_secret = automatorwp_instagram_get_option( 'client_secret', '' );

        $params = array(
            'headers' => array(
                'Content-Type'  => 'application/x-www-form-urlencoded; charset=utf-8',
                'Accept'        => 'application/json',
            ),
            'body'  => array(
				'client_id'	    => $client_id,
				'client_secret' => $client_secret,
                'grant_type'    => 'authorization_code',
                'redirect_uri'  => admin_url('admin.php'),
                'code'          => $_GET['code']
            )
        );

        $response = wp_remote_post( 'https://api.instagram.com/oauth/access_token', $params );
        
        // Bail if can't contact with the server
        if ( is_wp_error( $response ) ) {
            return;
        }

        $body = json_decode( wp_remote_retrieve_body( $response ) );

        // Bail on receive an error
        if( isset( $body->error ) ) {
            return;
        }

        $params_long_token = array(
            'body'  => array(
                'grant_type'    => 'ig_exchange_token',
                'client_secret' => $client_secret,
                'access_token'  => $body->access_token,
            )
        );

        $response_long_token = wp_remote_get( 'https://graph.instagram.com/access_token', $params_long_token );

        $body_long_token = json_decode( wp_remote_retrieve_body( $response_long_token ) );

        // Bail on receive an error
        if( isset( $body_long_token->error ) ) {
            return;
        }

        $auth = array(
            'access_token'  => $body_long_token->access_token,
            'token_type'    => $body_long_token->token_type,
            'expires_in'    => $body_long_token->expires_in,
        );

        // Update the access and refresh tokens
        update_option( 'automatorwp_instagram_auth', $auth );

        // To create schedule task to refresh token
        automatorwp_instagram_schedule_events();

        // Redirect to settings again
        wp_redirect( get_admin_url() . 'admin.php?page=automatorwp_settings&tab=opt-tab-instagram' );
        exit;

    }

}
add_action( 'admin_init', 'automatorwp_instagram_maybe_authorize_complete' );