<?php
/**
 * Ajax Functions
 *
 * @package     AutomatorWP\Integrations\Instagram\Ajax_Functions
 * @since       1.0.0
 */
// Exit if accessed directly
if( !defined( 'ABSPATH' ) ) exit;


/**
 * AJAX handler for the authorize action
 *
 * @since 1.0.0
 */
function automatorwp_instagram_ajax_authorize() {
    // Security check
    check_ajax_referer( 'automatorwp_admin', 'nonce' );

    $prefix = 'automatorwp_instagram_';

    $client_id = sanitize_text_field( $_POST['client_id'] );
    $client_secret = sanitize_text_field( $_POST['client_secret'] );
    $ig_id = sanitize_text_field( $_POST['ig_id'] );
   
    // Check parameters given
    if( empty( $client_id ) || empty( $client_secret ) ) {
        wp_send_json_error( array( 'message' => __( 'All fields are required to connect with Instagram', 'automatorwp-pro' ) ) );
    }

    $settings = get_option( 'automatorwp_settings' );

    // Save client id, client secret and Instagram ID
    $settings[$prefix . 'client_id'] = $client_id;
    $settings[$prefix . 'client_secret'] = $client_secret;
    $settings[$prefix . 'ig_id'] = $ig_id;
    
    // Update settings
    update_option( 'automatorwp_settings', $settings );

    // Permissions to use the Instagram API.
    $scope = 'instagram_business_basic,instagram_business_manage_messages,instagram_business_manage_comments,instagram_business_content_publish';  
	$admin_url = admin_url('admin.php');
    $redirect_url = 'https://www.instagram.com/oauth/authorize?client_id=' . $client_id . '&redirect_uri=' . $admin_url . '&response_type=code&scope=' . urlencode( $scope );

    // Return the redirect URL
    wp_send_json_success( array(
        'message' => __( 'Settings saved successfully, redirecting to Instagram...', 'automatorwp-pro' ),
        'redirect_url' => $redirect_url
    ) );

}
add_action( 'wp_ajax_automatorwp_instagram_authorize',  'automatorwp_instagram_ajax_authorize' );
