<?php
/**
 * Plugin Name:           AutomatorWP - JetFormBuilder
 * Plugin URI:            https://automatorwp.com/add-ons/jetformbuilder/
 * Description:           Connect AutomatorWP with JetFormBuilder.
 * Version:               1.0.1
 * Author:                AutomatorWP
 * Author URI:            https://automatorwp.com/
 * Text Domain:           automatorwp-jetformbuilder
 * Domain Path:           /languages/
 * Requires at least:     4.4
 * Tested up to:          6.4
 * License:               GNU AGPL v3.0 (http://www.gnu.org/licenses/agpl.txt)
 *
 * @package               AutomatorWP\JetFormBuilder
 * @author                AutomatorWP
 * @copyright             Copyright (c) AutomatorWP
 */

final class AutomatorWP_JetFormBuilder {

    /**
     * @var         AutomatorWP_JetFormBuilder $instance The one true AutomatorWP_JetFormBuilder
     * @since       1.0.0
     */
    private static $instance;

    /**
     * Get active instance
     *
     * @access      public
     * @since       1.0.0
     * @return      AutomatorWP_JetFormBuilder self::$instance The one true AutomatorWP_JetFormBuilder
     */
    public static function instance() {
        if( !self::$instance ) {
            self::$instance = new AutomatorWP_JetFormBuilder();
            self::$instance->constants();
            self::$instance->includes();
            self::$instance->hooks();            
        }

        return self::$instance;
    }

    /**
     * Setup plugin constants
     *
     * @access      private
     * @since       1.0.0
     * @return      void
     */
    private function constants() {
        // Plugin version
        define( 'AUTOMATORWP_JETFORMBUILDER_VER', '1.0.1' );

        // Plugin file
        define( 'AUTOMATORWP_JETFORMBUILDER_FILE', __FILE__ );

        // Plugin path
        define( 'AUTOMATORWP_JETFORMBUILDER_DIR', plugin_dir_path( __FILE__ ) );

        // Plugin URL
        define( 'AUTOMATORWP_JETFORMBUILDER_URL', plugin_dir_url( __FILE__ ) );
    }

    /**
     * Include plugin files
     *
     * @access      private
     * @since       1.0.0
     * @return      void
     */
    private function includes() {

        if( $this->meets_requirements() ) {

            // Triggers
            require_once AUTOMATORWP_JETFORMBUILDER_DIR . 'includes/triggers/submit-form.php';
            require_once AUTOMATORWP_JETFORMBUILDER_DIR . 'includes/triggers/submit-field-value.php';
            // Anonymous Triggers
            require_once AUTOMATORWP_JETFORMBUILDER_DIR . 'includes/triggers/anonymous-submit-form.php';
            require_once AUTOMATORWP_JETFORMBUILDER_DIR . 'includes/triggers/anonymous-submit-field-value.php';

            // Includes
            require_once AUTOMATORWP_JETFORMBUILDER_DIR . 'includes/functions.php';

        }
    }

    /**
     * Setup plugin hooks
     *
     * @access      private
     * @since       1.0.0
     * @return      void
     */
    private function hooks() {

        add_action( 'automatorwp_init', array( $this, 'register_integration' ) );
        
        

        
    }

    /**
     * Registers this integration
     *
     * @since 1.0.0
     */
    function register_integration() {

        automatorwp_register_integration( 'jetformbuilder', array(
            'label' => 'JetFormBuilder',
            'icon'  => AUTOMATORWP_JETFORMBUILDER_URL . 'assets/jetformbuilder.svg',
        ) );

    }

    /**
     * Check if there are all plugin requirements
     *
     * @since  1.0.0
     *
     * @return bool True if installation meets all requirements
     */
    private function meets_requirements() {

        if ( ! class_exists( 'AutomatorWP' ) ) {
            return false;
        }

        if ( ! function_exists( 'jet_form_builder_init' ) ) {
            return false;
        }

        return true;

    }

}

/**
 * The main function responsible for returning the one true AutomatorWP_JetFormBuilder instance to functions everywhere
 *
 * @since       1.0.0
 * @return      \AutomatorWP_JetFormBuilder The one true AutomatorWP_JetFormBuilder
 */
function AutomatorWP_JetFormBuilder() {
    return AutomatorWP_JetFormBuilder::instance();
}
add_action( 'plugins_loaded', 'AutomatorWP_JetFormBuilder' );
