<?php
/**
 * Plugin Name:           AutomatorWP - Jetpack CRM
 * Plugin URI:            https://automatorwp.com/add-ons/jetpack-crm/
 * Description:           Connect AutomatorWP with Jetpack CRM.
 * Version:               1.0.1
 * Author:                AutomatorWP
 * Author URI:            https://automatorwp.com/
 * Text Domain:           automatorwp-jetpack-crm
 * Domain Path:           /languages/
 * Requires at least:     4.4
 * Tested up to:          6.0
 * License:               GNU AGPL v3.0 (http://www.gnu.org/licenses/agpl.txt)
 *
 * @package               AutomatorWP\Jetpack_CRM
 * @author                AutomatorWP
 * @copyright             Copyright (c) AutomatorWP
 */

final class AutomatorWP_Jetpack_CRM {

    /**
     * @var         AutomatorWP_Jetpack_CRM $instance The one true AutomatorWP_Jetpack_CRM
     * @since       1.0.0
     */
    private static $instance;

    /**
     * Get active instance
     *
     * @access      public
     * @since       1.0.0
     * @return      AutomatorWP_Jetpack_CRM self::$instance The one true AutomatorWP_Jetpack_CRM
     */
    public static function instance() {
        if( !self::$instance ) {
            self::$instance = new AutomatorWP_Jetpack_CRM();
            self::$instance->constants();
            self::$instance->includes();
            self::$instance->hooks();            
        }

        return self::$instance;
    }

    /**
     * Setup plugin constants
     *
     * @access      private
     * @since       1.0.0
     * @return      void
     */
    private function constants() {
        // Plugin version
        define( 'AUTOMATORWP_JETPACK_CRM_VER', '1.0.1' );

        // Plugin file
        define( 'AUTOMATORWP_JETPACK_CRM_FILE', __FILE__ );

        // Plugin path
        define( 'AUTOMATORWP_JETPACK_CRM_DIR', plugin_dir_path( __FILE__ ) );

        // Plugin URL
        define( 'AUTOMATORWP_JETPACK_CRM_URL', plugin_dir_url( __FILE__ ) );
    }

    /**
     * Include plugin files
     *
     * @access      private
     * @since       1.0.0
     * @return      void
     */
    private function includes() {

        if( $this->meets_requirements() ) {

            // Includes
            require_once AUTOMATORWP_JETPACK_CRM_DIR . 'includes/ajax-functions.php';
            require_once AUTOMATORWP_JETPACK_CRM_DIR . 'includes/functions.php';
            require_once AUTOMATORWP_JETPACK_CRM_DIR . 'includes/tags.php';
            
            // Triggers
            require_once AUTOMATORWP_JETPACK_CRM_DIR . 'includes/triggers/company-added.php';
            require_once AUTOMATORWP_JETPACK_CRM_DIR . 'includes/triggers/company-deleted.php';
            require_once AUTOMATORWP_JETPACK_CRM_DIR . 'includes/triggers/contact-added.php';
            require_once AUTOMATORWP_JETPACK_CRM_DIR . 'includes/triggers/contact-deleted.php';
            require_once AUTOMATORWP_JETPACK_CRM_DIR . 'includes/triggers/invoice-added.php';
            require_once AUTOMATORWP_JETPACK_CRM_DIR . 'includes/triggers/invoice-deleted.php';
            require_once AUTOMATORWP_JETPACK_CRM_DIR . 'includes/triggers/quote-added.php';
            require_once AUTOMATORWP_JETPACK_CRM_DIR . 'includes/triggers/quote-deleted.php';
            require_once AUTOMATORWP_JETPACK_CRM_DIR . 'includes/triggers/transaction-added.php';
            require_once AUTOMATORWP_JETPACK_CRM_DIR . 'includes/triggers/transaction-deleted.php';
            require_once AUTOMATORWP_JETPACK_CRM_DIR . 'includes/triggers/contact-tag-added.php';
            require_once AUTOMATORWP_JETPACK_CRM_DIR . 'includes/triggers/contact-tag-removed.php';
            require_once AUTOMATORWP_JETPACK_CRM_DIR . 'includes/triggers/company-tag-added.php';
            require_once AUTOMATORWP_JETPACK_CRM_DIR . 'includes/triggers/company-tag-removed.php';
            require_once AUTOMATORWP_JETPACK_CRM_DIR . 'includes/triggers/quote-tag-added.php';
            require_once AUTOMATORWP_JETPACK_CRM_DIR . 'includes/triggers/quote-tag-removed.php';
            require_once AUTOMATORWP_JETPACK_CRM_DIR . 'includes/triggers/invoice-tag-added.php';
            require_once AUTOMATORWP_JETPACK_CRM_DIR . 'includes/triggers/invoice-tag-removed.php';
            require_once AUTOMATORWP_JETPACK_CRM_DIR . 'includes/triggers/transaction-tag-added.php';
            require_once AUTOMATORWP_JETPACK_CRM_DIR . 'includes/triggers/transaction-tag-removed.php';
            
            // ACTIONS
            require_once AUTOMATORWP_JETPACK_CRM_DIR . 'includes/actions/add-user.php';
            require_once AUTOMATORWP_JETPACK_CRM_DIR . 'includes/actions/delete-user.php';
            require_once AUTOMATORWP_JETPACK_CRM_DIR . 'includes/actions/contact-tag.php';
            require_once AUTOMATORWP_JETPACK_CRM_DIR . 'includes/actions/company-tag.php';
            require_once AUTOMATORWP_JETPACK_CRM_DIR . 'includes/actions/invoice-tag.php';
            require_once AUTOMATORWP_JETPACK_CRM_DIR . 'includes/actions/quote-tag.php';


        }
    }

    /**
     * Setup plugin hooks
     *
     * @access      private
     * @since       1.0.0
     * @return      void
     */
    private function hooks() {

        add_action( 'automatorwp_init', array( $this, 'register_integration' ) );
        
        

        
    }

    /**
     * Registers this integration
     *
     * @since 1.0.0
     */
    function register_integration() {

        automatorwp_register_integration( 'jetpack_crm', array(
            'label' => 'Jetpack CRM',
            'icon'  => AUTOMATORWP_JETPACK_CRM_URL . 'assets/jetpack-crm.svg',
        ) );

    }

    /**
     * Check if there are all plugin requirements
     *
     * @since  1.0.0
     *
     * @return bool True if installation meets all requirements
     */
    private function meets_requirements() {

        if ( ! class_exists( 'AutomatorWP' ) ) {
            return false;
        }

        if ( ! class_exists( 'ZeroBSCRM' ) ) {
            return false;
        }

        return true;

    }

}

/**
 * The main function responsible for returning the one true AutomatorWP_Jetpack_CRM instance to functions everywhere
 *
 * @since       1.0.0
 * @return      \AutomatorWP_Jetpack_CRM The one true AutomatorWP_Jetpack_CRM
 */
function AutomatorWP_Jetpack_CRM() {
    return AutomatorWP_Jetpack_CRM::instance();
}
add_action( 'plugins_loaded', 'AutomatorWP_Jetpack_CRM' );
