<?php
/**
 * Mark Section
 *
 * @package     AutomatorWP\Integrations\LifterLMS\Actions\Mark_Section
 * @author      AutomatorWP <contact@automatorwp.com>, Ruben Garcia <rubengcdev@gmail.com>
 * @since       1.0.0
 */
// Exit if accessed directly
if( !defined( 'ABSPATH' ) ) exit;

class AutomatorWP_LifterLMS_Mark_Section extends AutomatorWP_Integration_Action {

    public $integration = 'lifterlms';
    public $action = 'lifterlms_mark_section';

    /**
     * Register the trigger
     *
     * @since 1.0.0
     */
    public function register() {

        automatorwp_register_action( $this->action, array(
            'integration'       => $this->integration,
            'label'             => __( 'Mark section as completed or not completed', 'automatorwp-pro' ),
            'select_option'     => __( 'Mark section as <strong>completed or not completed</strong>', 'automatorwp-pro' ),
            /* translators: %1$s: Post title. %2$s: Operation (completed or not completed). */
            'edit_label'        => sprintf( __( 'Mark %1$s as %2$s', 'automatorwp-pro' ), '{post}', '{operation}' ),
            /* translators: %1$s: Post title. %2$s: Operation (completed or not completed). */
            'log_label'         => sprintf( __( 'Mark %1$s as %2$s', 'automatorwp-pro' ), '{post}', '{operation}' ),
            'options'           => array(
                'post' => automatorwp_utilities_post_option( array(
                    'name'              => __( 'Section:', 'automatorwp-pro' ),
                    'option_none_label' => __( 'all sections', 'automatorwp-pro' ),
                    'option_custom'         => true,
                    'option_custom_desc'    => __( 'Section ID', 'automatorwp-pro' ),
                    'post_type'         => 'section',
                ) ),
                'operation' => array(
                    'from' => 'operation',
                    'fields' => array(
                        'operation' => array(
                            'name' => __( 'Operation:', 'automatorwp-pro' ),
                            'type' => 'select',
                            'options' => array(
                                'complete'      => __( 'completed', 'automatorwp-pro' ),
                                'not_complete'  => __( 'not completed', 'automatorwp-pro' ),
                            ),
                            'default' => 'complete'
                        ),
                    )
                ),
            ),
        ) );

    }

    /**
     * Action execution function
     *
     * @since 1.0.0
     *
     * @param stdClass  $action             The action object
     * @param int       $user_id            The user ID
     * @param array     $action_options     The action's stored options (with tags already passed)
     * @param stdClass  $automation         The action's automation object
     */
    public function execute( $action, $user_id, $action_options, $automation ) {

        // Shorthand
        $operation = $action_options['operation'];
        $section_id = $action_options['post'];

        // Ensure operation default value
        if( empty( $operation ) ) {
            $operation = 'complete';
        }

        $sections = array();

        // Check specific section
        if( $section_id !== 'any' ) {

            $section = get_post( $section_id );

            // Bail if section doesn't exists
            if( ! $section ) {
                return;
            }

            $sections = array( $section_id );

        } else {

            $student = new LLMS_Student( $user_id );
            $user_courses = $student->get_courses( array( 'limit' => 999 ) );

            // Bail if user is not in any course
            if( empty( $user_courses['results'] ) ) {
                return;
            }

            foreach( $user_courses['results'] as $course_id ) {

                // Get the course object to get their sections
                $course = new LLMS_Course( $course_id );
                $sections = $course->get_sections();

                // Loop course sections
                foreach( $sections as $section ) {
                    $sections[] = $section->id;
                }

            }

        }

        switch ( $operation ) {
            case 'complete':
                // Loop all sections
                foreach( $sections as $section_id ) {

                    // Get the section object to get their lessons
                    $section = new LLMS_Section( $section_id );
                    $lessons = $section->get_lessons();

                    // Mark section lessons as completed
                    foreach ( $lessons as $lesson ) {
                        llms_mark_complete( $user_id, $lesson->id, 'lesson' );
                    }

                    // Mark sections as completed
                    llms_mark_complete( $user_id, $section_id, 'section' );
                }
                break;
            case 'not_complete':
                // Loop all sections
                foreach( $sections as $section_id ) {

                    // Get the section object to get their lessons
                    $section = new LLMS_Section( $section_id );
                    $lessons = $section->get_lessons();

                    // Mark section lessons as not completed completed
                    foreach ( $lessons as $lesson ) {
                        llms_mark_incomplete( $user_id, $lesson->id, 'lesson' );
                    }

                    // Mark sections as no completed
                    llms_mark_incomplete( $user_id, $section_id, 'section' );
                }
                break;
        }

    }

}

new AutomatorWP_LifterLMS_Mark_Section();