<?php
/**
 * Plugin Name:           AutomatorWP - MailerLite
 * Plugin URI:            https://automatorwp.com/add-ons/mailerlite/
 * Description:           Connect AutomatorWP with MailerLite.
 * Version:               1.0.6
 * Author:                AutomatorWP
 * Author URI:            https://automatorwp.com/
 * Text Domain:           automatorwp-mailerlite
 * Domain Path:           /languages/
 * Requires at least:     4.4
 * Tested up to:          6.7
 * License:               GNU AGPL v3.0 (http://www.gnu.org/licenses/agpl.txt)
 *
 * @package               AutomatorWP\MailerLite
 * @author                AutomatorWP
 * @copyright             Copyright (c) AutomatorWP
 */

final class AutomatorWP_MailerLite {

    /**
     * @var         AutomatorWP_MailerLite $instance The one true AutomatorWP_MailerLite
     * @since       1.0.0
     */
    private static $instance;

    /**
     * Get active instance
     *
     * @access      public
     * @since       1.0.0
     * @return      AutomatorWP_MailerLite self::$instance The one true AutomatorWP_MailerLite
     */
    public static function instance() {
        if( !self::$instance ) {
            self::$instance = new AutomatorWP_MailerLite();
            self::$instance->constants();
            self::$instance->includes();
            self::$instance->hooks();            
        }

        return self::$instance;
    }

    /**
     * Setup plugin constants
     *
     * @access      private
     * @since       1.0.0
     * @return      void
     */
    private function constants() {
        // Plugin version
        define( 'AUTOMATORWP_MAILERLITE_VER', '1.0.6' );

        // Plugin file
        define( 'AUTOMATORWP_MAILERLITE_FILE', __FILE__ );

        // Plugin path
        define( 'AUTOMATORWP_MAILERLITE_DIR', plugin_dir_path( __FILE__ ) );

        // Plugin URL
        define( 'AUTOMATORWP_MAILERLITE_URL', plugin_dir_url( __FILE__ ) );
    }


    /**
     * Include plugin files
     *
     * @access      private
     * @since       1.0.0
     * @return      void
     */
    private function includes() {

        if( $this->meets_requirements() ) {

            // Includes
            require_once AUTOMATORWP_MAILERLITE_DIR . 'includes/admin.php';
            require_once AUTOMATORWP_MAILERLITE_DIR . 'includes/functions.php';
            require_once AUTOMATORWP_MAILERLITE_DIR . 'includes/ajax-functions.php';
            require_once AUTOMATORWP_MAILERLITE_DIR . 'includes/scripts.php';

            // Actions
            require_once AUTOMATORWP_MAILERLITE_DIR . 'includes/actions/add-subscriber.php';
            require_once AUTOMATORWP_MAILERLITE_DIR . 'includes/actions/add-subscriber-group.php';
            require_once AUTOMATORWP_MAILERLITE_DIR . 'includes/actions/add-user.php';
            require_once AUTOMATORWP_MAILERLITE_DIR . 'includes/actions/add-user-group.php';
            require_once AUTOMATORWP_MAILERLITE_DIR . 'includes/actions/remove-user-group.php';
            require_once AUTOMATORWP_MAILERLITE_DIR . 'includes/actions/remove-subscriber-group.php';
            require_once AUTOMATORWP_MAILERLITE_DIR . 'includes/actions/create-group.php';
            require_once AUTOMATORWP_MAILERLITE_DIR . 'includes/actions/remove-group.php';
            require_once AUTOMATORWP_MAILERLITE_DIR . 'includes/actions/update-user-field.php';
            require_once AUTOMATORWP_MAILERLITE_DIR . 'includes/actions/update-subscriber-field.php';     

        }
    }

    /**
     * Setup plugin hooks
     *
     * @access      private
     * @since       1.0.0
     * @return      void
     */
    private function hooks() {

        add_action( 'automatorwp_init', array( $this, 'register_integration' ) );
        
        

        

    }

    
    /**
     * Registers this integration
     *
     * @since 1.0.0
     */
    function register_integration() {

        automatorwp_register_integration( 'mailerlite', array(
            'label' => 'MailerLite',
            'icon'  => AUTOMATORWP_MAILERLITE_URL . 'assets/mailerlite.svg',
        ) );

    }

    /**
     * Check if there are all plugin requirements
     *
     * @since  1.0.0
     *
     * @return bool True if installation meets all requirements
     */
    private function meets_requirements() {

        if ( ! class_exists( 'AutomatorWP' ) ) {
            return false;
        }

        return true;

    }

}

/**
 * The main function responsible for returning the one true AutomatorWP_MailerLite instance to functions everywhere
 *
 * @since       1.0.0
 * @return      \AutomatorWP_MailerLite The one true AutomatorWP_MailerLite
 */
function AutomatorWP_MailerLite() {
    return AutomatorWP_MailerLite::instance();
}
add_action( 'plugins_loaded', 'AutomatorWP_MailerLite' );
