<?php
/**
 * Plugin Name:           AutomatorWP - MailPoet
 * Plugin URI:            https://automatorwp.com/add-ons/mailpoet/
 * Description:           Connect AutomatorWP with MailPoet.
 * Version:               1.0.6
 * Author:                AutomatorWP
 * Author URI:            https://automatorwp.com/
 * Text Domain:           automatorwp-mailpoet
 * Domain Path:           /languages/
 * Requires at least:     4.4
 * Tested up to:          6.7
 * License:               GNU AGPL v3.0 (http://www.gnu.org/licenses/agpl.txt)
 *
 * @package               AutomatorWP\MailPoet
 * @author                AutomatorWP
 * @copyright             Copyright (c) AutomatorWP
 */

final class AutomatorWP_MailPoet {

    /**
     * @var         AutomatorWP_MailPoet $instance The one true AutomatorWP_MailPoet
     * @since       1.0.0
     */
    private static $instance;

    /**
     * Get active instance
     *
     * @access      public
     * @since       1.0.0
     * @return      AutomatorWP_MailPoet self::$instance The one true AutomatorWP_MailPoet
     */
    public static function instance() {
        if( !self::$instance ) {
            self::$instance = new AutomatorWP_MailPoet();
            self::$instance->constants();
            self::$instance->includes();
            self::$instance->hooks();            
        }

        return self::$instance;
    }

    /**
     * Setup plugin constants
     *
     * @access      private
     * @since       1.0.0
     * @return      void
     */
    private function constants() {
        // Plugin version
        define( 'AUTOMATORWP_MAILPOET_VER', '1.0.6' );

        // Plugin file
        define( 'AUTOMATORWP_MAILPOET_FILE', __FILE__ );

        // Plugin path
        define( 'AUTOMATORWP_MAILPOET_DIR', plugin_dir_path( __FILE__ ) );

        // Plugin URL
        define( 'AUTOMATORWP_MAILPOET_URL', plugin_dir_url( __FILE__ ) );
    }

    /**
     * Include plugin files
     *
     * @access      private
     * @since       1.0.0
     * @return      void
     */
    private function includes() {

        if( $this->meets_requirements() ) {

            // Includes
            require_once AUTOMATORWP_MAILPOET_DIR . 'includes/functions.php';
            require_once AUTOMATORWP_MAILPOET_DIR . 'includes/ajax-functions.php';

            // Actions
            require_once AUTOMATORWP_MAILPOET_DIR . 'includes/actions/add-user-to-list.php';
            require_once AUTOMATORWP_MAILPOET_DIR . 'includes/actions/add-subscriber-to-list.php';
            require_once AUTOMATORWP_MAILPOET_DIR . 'includes/actions/remove-user-from-list.php';
            require_once AUTOMATORWP_MAILPOET_DIR . 'includes/actions/remove-subscriber-from-list.php';

            // Triggers
            require_once AUTOMATORWP_MAILPOET_DIR . 'includes/triggers/submit-form.php';
            require_once AUTOMATORWP_MAILPOET_DIR . 'includes/triggers/anonymous-submit-form.php';

        }
    }

    /**
     * Setup plugin hooks
     *
     * @access      private
     * @since       1.0.0
     * @return      void
     */
    private function hooks() {

        add_action( 'automatorwp_init', array( $this, 'register_integration' ) );
        
        

        
    }

    /**
     * Registers this integration
     *
     * @since 1.0.0
     */
    function register_integration() {

        automatorwp_register_integration( 'mailpoet', array(
            'label' => 'MailPoet',
            'icon'  => AUTOMATORWP_MAILPOET_URL . 'assets/mailpoet.svg',
        ) );

    }

    /**
     * Check if there are all plugin requirements
     *
     * @since  1.0.0
     *
     * @return bool True if installation meets all requirements
     */
    private function meets_requirements() {

        if ( ! class_exists( 'AutomatorWP' ) ) {
            return false;
        }

        if ( ! defined( 'MAILPOET_VERSION' ) ) {
            return false;
        }

        return true;

    }

}

/**
 * The main function responsible for returning the one true AutomatorWP_MailPoet instance to functions everywhere
 *
 * @since       1.0.0
 * @return      \AutomatorWP_MailPoet The one true AutomatorWP_MailPoet
 */
function AutomatorWP_MailPoet() {
    return AutomatorWP_MailPoet::instance();
}
add_action( 'plugins_loaded', 'AutomatorWP_MailPoet' );
