<?php
/**
 * Ajax Functions
 *
 * @package     AutomatorWP\OpenAI\Ajax_Functions
 * @since       1.0.0
 */
// Exit if accessed directly
if( !defined( 'ABSPATH' ) ) exit;

/**
 * AJAX handler for the authorize action
 *
 * @since 1.0.0
 */
function automatorwp_openai_ajax_authorize() {
    // Security check
    check_ajax_referer( 'automatorwp_admin', 'nonce' );

    $prefix = 'automatorwp_openai_';

    $url = automatorwp_openai_get_url();
    $token = sanitize_text_field( $_POST['token'] );
    $model = sanitize_text_field( $_POST['model'] );
   
    // Check parameters given
    if( empty( $token ) ) {
        wp_send_json_error( array( 'message' => __( 'API Token is required to connect with OpenAI', 'automatorwp-pro' ) ) );
        return;
    }
    
    // To get first answer and check the connection
    $response = wp_remote_get( $url . '/v1/models', array(
        'headers' => array(
            'Authorization' => 'Bearer ' . $token,
            'Content-Type'  => 'application/json'
        )
    ) );

    // Incorrect API token
    if ( isset( $response['response']['code'] ) && $response['response']['code'] !== 200 ) {
        wp_send_json_error (array( 'message' => __( 'Please, check your credentials', 'automatorwp-pro' ) ) );
        return;
    }

    $settings = get_option( 'automatorwp_settings' );

    // Save API key and model
    $settings[$prefix . 'token'] = $token;
    $settings[$prefix . 'model'] = $model;

    // Update settings
    update_option( 'automatorwp_settings', $settings );
    $admin_url = admin_url( 'admin.php?page=automatorwp_settings&tab=opt-tab-openai' );
   
    wp_send_json_success( array(
        'message' => __( 'Correct data to connect with OpenAI', 'automatorwp-pro' ),
        'redirect_url' => $admin_url
    ) );

}
add_action( 'wp_ajax_automatorwp_openai_authorize',  'automatorwp_openai_ajax_authorize' );
