<?php
/**
 * Filters
 *
 * @package     AutomatorWP\Restrict_Content\Filters
 * @author      AutomatorWP <contact@automatorwp.com>, Ruben Garcia <rubengcdev@gmail.com>
 * @since       1.0.0
 */
// Exit if accessed directly
if( !defined( 'ABSPATH' ) ) exit;

/**
 * Detect when a user is added to a level
 *
 * @since 1.0.0
 */
function automatorwp_restrict_content_on_add_user_to_access_level( $object_id, $object, $update ) {

    global $ct_table;

    if( $ct_table->name !== 'automatorwp_restrict_content_access_level_users' ) {
        return;
    }

    $access_level_user = ct_get_object( $object_id );

    do_action( 'automatorwp_restrict_content_user_added_to_access_level', $access_level_user->level_id, $access_level_user->user_id, $access_level_user );

}
add_action( 'ct_insert_object', 'automatorwp_restrict_content_on_add_user_to_access_level', 10, 3 );

/**
 * Detect when a user is removed from a level
 *
 * @since 1.0.0
 */
function automatorwp_restrict_content_on_remove_user_to_access_level( $object_id ) {

    global $ct_table;

    if( $ct_table->name !== 'automatorwp_restrict_content_access_level_users' ) {
        return;
    }

    $access_level_user = ct_get_object( $object_id );

    do_action( 'automatorwp_restrict_content_user_removed_from_access_level', $access_level_user->level_id, $access_level_user->user_id, $access_level_user );

}
add_action( 'before_delete_object', 'automatorwp_restrict_content_on_remove_user_to_access_level' );

/**
 * Detect when a level is removed to delete all relationships
 *
 * @since 1.0.0
 */
function automatorwp_restrict_content_on_remove_level( $object_id ) {

    global $wpdb, $ct_table;

    if( $ct_table->name !== 'automatorwp_restrict_content_access_levels' ) {
        return;
    }

    // Setup table
    $ct_table = ct_setup_table( 'automatorwp_restrict_content_access_level_users' );

    // Delete all users entries in this level
    $wpdb->query( "DELETE FROM {$ct_table->db->table_name} WHERE level_id = {$object_id}" );

    ct_reset_setup_table();
}
add_action( 'before_delete_object', 'automatorwp_restrict_content_on_remove_level' );
