<?php
/**
 * Plugin Name:           AutomatorWP - Twilio
 * Plugin URI:            https://automatorwp.com/add-ons/twilio/
 * Description:           Connect AutomatorWP with Twilio.
 * Version:               1.0.0
 * Author:                AutomatorWP
 * Author URI:            https://automatorwp.com/
 * Text Domain:           automatorwp-twilio
 * Domain Path:           /languages/
 * Requires at least:     4.4
 * Tested up to:          5.5
 * License:               GNU AGPL v3.0 (http://www.gnu.org/licenses/agpl.txt)
 *
 * @package               AutomatorWP\Twilio
 * @author                AutomatorWP
 * @copyright             Copyright (c) AutomatorWP
 */

final class AutomatorWP_Twilio {

    /**
     * @var         AutomatorWP_Twilio $instance The one true AutomatorWP_Twilio
     * @since       1.0.0
     */
    private static $instance;

    /**
     * Get active instance
     *
     * @access      public
     * @since       1.0.0
     * @return      AutomatorWP_Twilio self::$instance The one true AutomatorWP_Twilio
     */
    public static function instance() {
        if( !self::$instance ) {
            self::$instance = new AutomatorWP_Twilio();
            self::$instance->constants();
            self::$instance->libraries();
            self::$instance->includes();
            self::$instance->hooks();            
        }

        return self::$instance;
    }

    /**
     * Setup plugin constants
     *
     * @access      private
     * @since       1.0.0
     * @return      void
     */
    private function constants() {
        // Plugin version
        define( 'AUTOMATORWP_TWILIO_VER', '1.0.0' );

        // Plugin file
        define( 'AUTOMATORWP_TWILIO_FILE', __FILE__ );

        // Plugin path
        define( 'AUTOMATORWP_TWILIO_DIR', plugin_dir_path( __FILE__ ) );

        // Plugin URL
        define( 'AUTOMATORWP_TWILIO_URL', plugin_dir_url( __FILE__ ) );
    }

    /**
     * Include plugin libraries
     *
     * @access      private
     * @since       1.0.0
     * @return      void
     */
    private function libraries() {

        // Twilio SDK
        require_once AUTOMATORWP_TWILIO_DIR . 'vendor/autoload.php';
    }

    /**
     * Include plugin files
     *
     * @access      private
     * @since       1.0.0
     * @return      void
     */
    private function includes() {

        if( $this->meets_requirements() ) {

            // Includes
            require_once AUTOMATORWP_TWILIO_DIR . 'includes/admin.php';
            require_once AUTOMATORWP_TWILIO_DIR . 'includes/functions.php';
            require_once AUTOMATORWP_TWILIO_DIR . 'includes/scripts.php';

            // Actions
            require_once AUTOMATORWP_TWILIO_DIR . 'includes/actions/send-sms.php';

        }
    }

    /**
     * Setup plugin hooks
     *
     * @access      private
     * @since       1.0.0
     * @return      void
     */
    private function hooks() {

        add_action( 'automatorwp_init', array( $this, 'register_integration' ) );
        
        

        
    }

    /**
     * Registers this integration
     *
     * @since 1.0.0
     */
    function register_integration() {

        automatorwp_register_integration( 'twilio', array(
            'label' => 'Twilio',
            'icon'  => AUTOMATORWP_TWILIO_URL . 'assets/twilio.svg',
        ) );

    }

    /**
     * Check if there are all plugin requirements
     *
     * @since  1.0.0
     *
     * @return bool True if installation meets all requirements
     */
    private function meets_requirements() {

        if ( ! class_exists( 'AutomatorWP' ) ) {
            return false;
        }

        return true;

    }

}

/**
 * The main function responsible for returning the one true AutomatorWP_Twilio instance to functions everywhere
 *
 * @since       1.0.0
 * @return      \AutomatorWP_Twilio The one true AutomatorWP_Twilio
 */
function AutomatorWP_Twilio() {
    return AutomatorWP_Twilio::instance();
}
add_action( 'plugins_loaded', 'AutomatorWP_Twilio' );
