(function ( $ ) {

    // On click remove user from list
    $('body').on('click', '.automatorwp-user-lists-remove-button', function(e) {
        e.preventDefault();

        var $this = $(this);
        var url = $this.attr('href');
        var tr = $this.closest('tr');

        var user_id = $this.data('user-id');

        if( $this.hasClass('disabled') ) {
            return;
        }

        // Disable the button
        $this.addClass('disabled');

        // Call the URL to remove the item
        $.ajax({
            url: automatorwp_user_lists_admin.ajaxurl,
            data: {
                action: 'automatorwp_user_lists_remove_user_from_list',
                nonce: automatorwp_user_lists_admin.nonce,
                list_id: $('#ct_edit_form input#object_id').val(),
                user_id: user_id,
            },
            success: function( response ) {
                $('.automatorwp-user-list-add-user-message').html(response.data);
                automatorwp_user_lists_refresh_ajax_table();

                // Restore the button
                $this.removeClass('disabled');
            }
        });

    });

    // User Selector Control
    $('.automatorwp-user-selector select').each(function() { automatorwp_user_selector( $(this) ); });

    // On click remove user from list
    $('body').on('click', '.automatorwp-user-lists-add-user-button', function(e) {
        e.preventDefault();

        var $this = $(this);

        var user_id = $('select#automatorwp-user-lists-user-id').val();

        if( user_id === null ) {
            $('.automatorwp-user-list-add-user-message').html( automatorwp_user_lists_admin.no_user_selected );
            return;
        }

        if( $this.hasClass('disabled') ) {
            return;
        }

        $('.automatorwp-user-list-add-user-message').html('');

        // Disable the button
        $this.addClass('disabled');

        $.ajax({
            url: automatorwp_user_lists_admin.ajaxurl,
            data: {
                action: 'automatorwp_user_lists_add_user_to_list',
                nonce: automatorwp_user_lists_admin.nonce,
                list_id: $('#ct_edit_form input#object_id').val(),
                user_id: user_id,
            },
            success: function( response ) {

                $('.automatorwp-user-list-add-user-message').html(response.data);

                automatorwp_user_lists_refresh_ajax_table();

                // Restore the button
                $this.removeClass('disabled');
            }
        });

    });

    function automatorwp_user_lists_refresh_ajax_table() {

        var $ = $ || jQuery;

        var table = $('.ct-ajax-list-table[data-object="automatorwp_user_lists_users"]');

        // Refresh the table
        ct_ajax_list_table_paginate_table( table, table.find('input#current-page-selector').val() );

    }

})( jQuery );