<?php
/**
 * Plugin Name:           AutomatorWP - WhatsApp
 * Plugin URI:            https://automatorwp.com/add-ons/whatsapp/
 * Description:           Connect AutomatorWP with WhatsApp.
 * Version:               1.0.0
 * Author:                AutomatorWP
 * Author URI:            https://automatorwp.com/
 * Text Domain:           automatorwp-whatsapp
 * Domain Path:           /languages/
 * Requires at least:     4.4
 * Tested up to:          6.8
 * License:               GNU AGPL v3.0 (http://www.gnu.org/licenses/agpl.txt)
 *
 * @package               AutomatorWP\WhatsApp
 * @author                AutomatorWP
 * @copyright             Copyright (c) AutomatorWP
 */

final class AutomatorWP_WhatsApp {

    /**
     * @var         AutomatorWP_WhatsApp $instance The one true AutomatorWP_WhatsApp
     * @since       1.0.0
     */
    private static $instance;

    /**
     * Get active instance
     *
     * @access      public
     * @since       1.0.0
     * @return      AutomatorWP_WhatsApp self::$instance The one true AutomatorWP_WhatsApp
     */
    public static function instance() {
        if( !self::$instance ) {
            self::$instance = new AutomatorWP_WhatsApp();
            self::$instance->constants();
            self::$instance->includes();
            self::$instance->hooks();            
        }

        return self::$instance;
    }

    /**
     * Setup plugin constants
     *
     * @access      private
     * @since       1.0.0
     * @return      void
     */
    private function constants() {
        // Plugin version
        define( 'AUTOMATORWP_WHATSAPP_VER', '1.0.0' );

        // Plugin file
        define( 'AUTOMATORWP_WHATSAPP_FILE', __FILE__ );

        // Plugin path
        define( 'AUTOMATORWP_WHATSAPP_DIR', plugin_dir_path( __FILE__ ) );

        // Plugin URL
        define( 'AUTOMATORWP_WHATSAPP_URL', plugin_dir_url( __FILE__ ) );
    }

    /**
     * Include plugin files
     *
     * @access      private
     * @since       1.0.0
     * @return      void
     */
    private function includes() {

        if( $this->meets_requirements() ) {

            // Includes
            require_once AUTOMATORWP_WHATSAPP_DIR . 'includes/admin.php';
            require_once AUTOMATORWP_WHATSAPP_DIR . 'includes/ajax-functions.php';
            require_once AUTOMATORWP_WHATSAPP_DIR . 'includes/functions.php';
            require_once AUTOMATORWP_WHATSAPP_DIR . 'includes/scripts.php';
            require_once AUTOMATORWP_WHATSAPP_DIR . 'includes/rest-api.php';
            require_once AUTOMATORWP_WHATSAPP_DIR . 'includes/tags.php';

            // Triggers
            require_once AUTOMATORWP_WHATSAPP_DIR . 'includes/triggers/anonymous-message-received.php';

            // Actions
            require_once AUTOMATORWP_WHATSAPP_DIR . 'includes/actions/send-message.php';
            require_once AUTOMATORWP_WHATSAPP_DIR . 'includes/actions/send-message-template.php';

        }
    }

    /**
     * Setup plugin hooks
     *
     * @access      private
     * @since       1.0.0
     * @return      void
     */
    private function hooks() {

        add_action( 'automatorwp_init', array( $this, 'register_integration' ) );
        
        // Setup our activation and deactivation hooks
        register_activation_hook( __FILE__, array( $this, 'activate' ) );
        register_deactivation_hook( __FILE__, array( $this, 'deactivate' ) );
        

        
    }

    /**
     * Registers this integration
     *
     * @since 1.0.0
     */
    function register_integration() {

        automatorwp_register_integration( 'whatsapp', array(
            'label' => 'WhatsApp',
            'icon'  => AUTOMATORWP_WHATSAPP_URL . 'assets/whatsapp.svg',
        ) );

    }

    /**
     * Activation hook for the plugin.
     *
     * @since  1.0.0
     */
    function activate() {

        if( $this->meets_requirements() ) {

        }

    }

    /**
     * Deactivation hook for the plugin.
     *
     * @since  1.0.0
     */
    function deactivate() {

    }

    /**
     * Check if there are all plugin requirements
     *
     * @since  1.0.0
     *
     * @return bool True if installation meets all requirements
     */
    private function meets_requirements() {

        if ( ! class_exists( 'AutomatorWP' ) ) {
            return false;
        }

        return true;

    }

}

/**
 * The main function responsible for returning the one true AutomatorWP_WhatsApp instance to functions everywhere
 *
 * @since       1.0.0
 * @return      \AutomatorWP_WhatsApp The one true AutomatorWP_WhatsApp
 */
function AutomatorWP_WhatsApp() {
    return AutomatorWP_WhatsApp::instance();
}
add_action( 'plugins_loaded', 'AutomatorWP_WhatsApp' );

