<?php
/**
 * Plugin Name:           AutomatorWP - WP Job Manager
 * Plugin URI:            https://automatorwp.com/add-ons/wp-job-manager/
 * Description:           Connect AutomatorWP with WP Job Manager.
 * Version:               1.0.2
 * Author:                AutomatorWP
 * Author URI:            https://automatorwp.com/
 * Text Domain:           automatorwp-wp-job-manager
 * Domain Path:           /languages/
 * Requires at least:     4.4
 * Tested up to:          5.8
 * License:               GNU AGPL v3.0 (http://www.gnu.org/licenses/agpl.txt)
 *
 * @package               AutomatorWP\WP_Job_Manager
 * @author                AutomatorWP
 * @copyright             Copyright (c) AutomatorWP
 */

final class AutomatorWP_WP_Job_Manager {

    /**
     * @var         AutomatorWP_WP_Job_Manager $instance The one true AutomatorWP_WP_Job_Manager
     * @since       1.0.0
     */
    private static $instance;

    /**
     * Get active instance
     *
     * @access      public
     * @since       1.0.0
     * @return      AutomatorWP_WP_Job_Manager self::$instance The one true AutomatorWP_WP_Job_Manager
     */
    public static function instance() {
        if( !self::$instance ) {
            self::$instance = new AutomatorWP_WP_Job_Manager();
            self::$instance->constants();
            self::$instance->includes();
            self::$instance->hooks();            
        }

        return self::$instance;
    }

    /**
     * Setup plugin constants
     *
     * @access      private
     * @since       1.0.0
     * @return      void
     */
    private function constants() {
        // Plugin version
        define( 'AUTOMATORWP_WP_JOB_MANAGER_VER', '1.0.2' );

        // Plugin file
        define( 'AUTOMATORWP_WP_JOB_MANAGER_FILE', __FILE__ );

        // Plugin path
        define( 'AUTOMATORWP_WP_JOB_MANAGER_DIR', plugin_dir_path( __FILE__ ) );

        // Plugin URL
        define( 'AUTOMATORWP_WP_JOB_MANAGER_URL', plugin_dir_url( __FILE__ ) );
    }

    /**
     * Include plugin files
     *
     * @access      private
     * @since       1.0.0
     * @return      void
     */
    private function includes() {

        if( $this->meets_requirements() ) {

            // Triggers
            require_once AUTOMATORWP_WP_JOB_MANAGER_DIR . 'includes/triggers/publish-job.php';
            require_once AUTOMATORWP_WP_JOB_MANAGER_DIR . 'includes/triggers/job-filled.php';
            require_once AUTOMATORWP_WP_JOB_MANAGER_DIR . 'includes/triggers/job-not-filled.php';
            // Applications
            require_once AUTOMATORWP_WP_JOB_MANAGER_DIR . 'includes/triggers/apply-job.php';
            require_once AUTOMATORWP_WP_JOB_MANAGER_DIR . 'includes/triggers/get-application.php';
            require_once AUTOMATORWP_WP_JOB_MANAGER_DIR . 'includes/triggers/application-status.php';

        }
    }

    /**
     * Setup plugin hooks
     *
     * @access      private
     * @since       1.0.0
     * @return      void
     */
    private function hooks() {

        add_action( 'automatorwp_init', array( $this, 'register_integration' ) );
        
        // Setup our activation and deactivation hooks
        register_activation_hook( __FILE__, array( $this, 'activate' ) );
        register_deactivation_hook( __FILE__, array( $this, 'deactivate' ) );
        

        
    }

    /**
     * Registers this integration
     *
     * @since 1.0.0
     */
    function register_integration() {

        automatorwp_register_integration( 'wp_job_manager', array(
            'label' => 'WP Job Manager',
            'icon'  => AUTOMATORWP_WP_JOB_MANAGER_URL . 'assets/wp-job-manager.svg',
        ) );

    }

    /**
     * Activation hook for the plugin.
     *
     * @since  1.0.0
     */
    function activate() {

        if( $this->meets_requirements() ) {

        }

    }

    /**
     * Deactivation hook for the plugin.
     *
     * @since  1.0.0
     */
    function deactivate() {

    }

    /**
     * Check if there are all plugin requirements
     *
     * @since  1.0.0
     *
     * @return bool True if installation meets all requirements
     */
    private function meets_requirements() {

        if ( ! class_exists( 'AutomatorWP' ) ) {
            return false;
        }

        if ( ! class_exists( 'WP_Job_Manager' ) ) {
            return false;
        }

        return true;

    }

}

/**
 * The main function responsible for returning the one true AutomatorWP_WP_Job_Manager instance to functions everywhere
 *
 * @since       1.0.0
 * @return      \AutomatorWP_WP_Job_Manager The one true AutomatorWP_WP_Job_Manager
 */
function AutomatorWP_WP_Job_Manager() {
    return AutomatorWP_WP_Job_Manager::instance();
}
add_action( 'plugins_loaded', 'AutomatorWP_WP_Job_Manager' );
