<?php
/**
 * Functions
 *
 * @package     AutomatorWP\Integrations\Amelia\Includes\Functions
 * @since       1.0.0
 */
// Exit if accessed directly
if( !defined( 'ABSPATH' ) ) exit;

/**
 * Get services from Amelia
 *
 * @since 1.0.0
 * 
 * @param stdClass $field
 *
 * @return array
 */
function automatorwp_ameliabooking_options_cb_service( $field ) {

    // Setup vars
    $value = $field->escaped_value;
    $none_value = 'any';
    $none_label = __( 'any service', 'automatorwp-pro' );
    $options = automatorwp_options_cb_none_option( $field, $none_value, $none_label );
    
    if( ! empty( $value ) ) {
        if( ! is_array( $value ) ) {
            $value = array( $value );
        }

        foreach( $value as $service_id ) {

            // Skip option none
            if( $service_id === $none_value ) {
                continue;
            }
            
            $options[$service_id] = automatorwp_ameliabooking_get_service_name( $service_id );
        }
    }

    return $options;

}

/**
 * Get Amelia services
 *
 * @since 1.0.0
 *
 * @return array|false
 */
function automatorwp_ameliabooking_get_services() {

    global $wpdb;
    $services = array( );

    $results = $wpdb->get_results( "SELECT id, name FROM {$wpdb->prefix}amelia_services" );

    foreach ( $results as $service ){   

        $services[] = array(
            'id'    => $service->id,
            'name'  => $service->name,
        );         

    }

    return $services;

}

/**
 * Get Amelia service name
 *
 * @since 1.0.0
 *
 * @param int    $service_id         ID service
 * 
 */
function automatorwp_ameliabooking_get_service_name( $service_id ) {

    global $wpdb;

    $service_name = $wpdb->get_var( "SELECT name FROM {$wpdb->prefix}amelia_services WHERE id = {$service_id}" );
    
    return $service_name;

}

/**
 * Get events from Amelia
 *
 * @since 1.0.0
 * 
 * @param stdClass $field
 *
 * @return array
 */
function automatorwp_ameliabooking_options_cb_event( $field ) {

    // Setup vars
    $value = $field->escaped_value;
    $none_value = 'any';
    $none_label = __( 'any event', 'automatorwp-pro' );
    $options = automatorwp_options_cb_none_option( $field, $none_value, $none_label );
    
    if( ! empty( $value ) ) {
        if( ! is_array( $value ) ) {
            $value = array( $value );
        }

        foreach( $value as $event_id ) {

            // Skip option none
            if( $event_id === $none_value ) {
                continue;
            }
            
            $options[$event_id] = automatorwp_ameliabooking_get_event_name( $event_id );
        }
    }

    return $options;

}


/**
 * Get Amelia events
 *
 * @since 1.0.0
 *
 * @return array|false
 */
function automatorwp_ameliabooking_get_events() {

    global $wpdb;
    $events = array( );
    // end test

    $results = $wpdb->get_results( "SELECT id, name, status, maxCapacity, bookingCloses FROM {$wpdb->prefix}amelia_events" );

    // Get current date to compare with end period
    $date = date( "Y-m-d H:i:s" );

    foreach ( $results as $event ){   
        
        if ( $event->status !== 'rejected' ){

            $event_periodStart = automatorwp_ameliabooking_get_date_close( $event->id );
            
            $event_capacity = automatorwp_ameliabooking_check_capacity( $event->id );
            // To check if event is full
            if ($event_capacity < $event->maxCapacity){
                // To compare if event is opened
                if ( $date < $event_periodStart || $date < $event->bookingCloses){

                    $events[] = array(
                        'id'    => $event->id,
                        'name'  => $event->name,
                    );         

                }
            }
            
            
        }
        
    }

    return $events;

}

/**
 * Get Amelia event date close. An event is closed when start if a date is not specified in Amelia settings
 *
 * @since 1.0.0
 *
 * @param int   $event_id   ID event
 * 
 * @return date
 * 
 */
function automatorwp_ameliabooking_get_date_close( $event_id ) {

    global $wpdb;

    $event_periodStart = $wpdb->get_var( "SELECT periodStart FROM {$wpdb->prefix}amelia_events_periods WHERE eventId = {$event_id}" );

    return $event_periodStart;

}

/**
 * Check if event is full
 *
 * @since 1.0.0
 *
 * @param int   $event_id   ID event
 * 
 * @return date
 * 
 */
function automatorwp_ameliabooking_check_capacity( $event_id ) {

    global $wpdb;

    $event_counter = $wpdb->get_var( "SELECT COUNT(id) FROM {$wpdb->prefix}amelia_customer_bookings_to_events_periods WHERE eventPeriodId = {$event_id}" );

    return $event_counter;

}


/**
 * Get Amelia event name
 *
 * @since 1.0.0
 *
 * @param int   $event_id   ID event
 * 
 * @return string
 * 
 */
function automatorwp_ameliabooking_get_event_name( $event_id ) {

    global $wpdb;

    $event_name = $wpdb->get_var( "SELECT name FROM {$wpdb->prefix}amelia_events WHERE id = {$event_id}" );
    
    return $event_name;

}