<?php
/**
 * Subscribe User Forum
 *
 * @package     AutomatorWP\Integrations\BuddyBoss\Actions\Subscribe_User_Forum
 * @author      AutomatorWP <contact@automatorwp.com>, Ruben Garcia <rubengcdev@gmail.com>
 * @since       1.0.0
 */
// Exit if accessed directly
if( !defined( 'ABSPATH' ) ) exit;

class AutomatorWP_BuddyBoss_Subscribe_User_Forum extends AutomatorWP_Integration_Action {

    public $integration = 'buddyboss';
    public $action = 'buddyboss_subscribe_user_forum';

    /**
     * Register the trigger
     *
     * @since 1.0.0
     */
    public function register() {

        automatorwp_register_action( $this->action, array(
            'integration'       => $this->integration,
            'label'             => __( 'Subscribe user to forum', 'automatorwp-pro' ),
            'select_option'     => __( 'Subscribe user to <strong>forum</strong>', 'automatorwp-pro' ),
            /* translators: %1$s: User. %2$s: Forum Title. */
            'edit_label'        => sprintf( __( 'Subscribe %1$s to %2$s', 'automatorwp-pro' ), '{user}', '{forum}' ),
            /* translators: %1$s: User. %2$s: Forum Title. */
            'log_label'         => sprintf( __( 'Subscribe %1$s to %2$s', 'automatorwp-pro' ), '{user}', '{forum}' ),
            'options'           => array(
                'user' => array(
                    'from' => 'user',
                    'default' => __( 'user', 'automatorwp-pro' ),
                    'fields' => array(
                        'user' => array(
                            'name' => __( 'User ID:', 'automatorwp-pro' ),
                            'desc' => __( 'User ID that will get subscribed to the forum. Leave blank to subscribe the user that completes the automation.', 'automatorwp-pro' ),
                            'type' => 'text',
                            'default' => ''
                        ),
                    )
                ),
                'forum' => array(
                    'from' => 'forum',
                    'fields' => array(
                        'forum' => automatorwp_utilities_post_field( array(
                            'name' => __( 'Forum:', 'automatorwp-pro' ),
                            'option_none_label' => __( 'any forum', 'automatorwp-pro' ),
                            'post_type_cb' => 'bbp_get_forum_post_type'
                        ) )
                    )
                ),
            ),
        ) );

    }

    /**
     * Action execution function
     *
     * @since 1.0.0
     *
     * @param stdClass  $action             The action object
     * @param int       $user_id            The user ID
     * @param array     $action_options     The action's stored options (with tags already passed)
     * @param stdClass  $automation         The action's automation object
     */
    public function execute( $action, $user_id, $action_options, $automation ) {

        // Shorthand
        $forum_id = $action_options['forum'];
        $user_id_to_subscribe = absint( $action_options['user'] );

        // Bail if forum not provided
        if( absint( $forum_id ) === 0 ) {
            return;
        }

        if( $user_id_to_subscribe === 0 ) {
            $user_id_to_subscribe = $user_id;
        }

        // Subscribe user to the forum
        bbp_add_user_forum_subscription( $user_id_to_subscribe, $forum_id );

    }

}

new AutomatorWP_BuddyBoss_Subscribe_User_Forum();