<?php
/**
 * Ajax Functions
 *
 * @package     AutomatorWP\BuddyBoss\Ajax_Functions
 * @since       1.0.0
 */
// Exit if accessed directly
if( !defined( 'ABSPATH' ) ) exit;

/**
 * Ajax function for selecting groups
 *
 * @since 1.0.0
 */
function automatorwp_buddyboss_ajax_get_groups() {
    // Security check, forces to die if not security passed
    check_ajax_referer( 'automatorwp_admin', 'nonce' );

    global $wpdb;

    $results = array();

    // Pull back the search string
    $search = isset( $_REQUEST['q'] ) ? $wpdb->esc_like( $_REQUEST['q'] ) : '';
    $page = isset( $_REQUEST['page'] ) ? absint( $_REQUEST['page'] ) : 1;

    if( bp_is_active( 'groups' ) ) {

        // Bail if BuddyBoss function does not exist
        if ( ! function_exists( 'groups_get_group' ) ) {
            return $results;
        }

        // Get the groups
        $groups = groups_get_groups( array(
            'search_terms' => $search,
            'show_hidden' => true,
            'per_page' => 20,
            'page' => $page
        ) );

        if( isset( $groups['groups'] ) && ! empty( $groups['groups'] ) ) {
            foreach ( $groups['groups'] as $group ) {

                // Results should meet Select2 structure
                $results[] = array(
                    'id' => $group->id,
                    'text' => $group->name,
                );

            }
        }

    }

    // Prepend option none
    $results = automatorwp_ajax_get_ajax_results_option_none( $results );

    // Return our results
    wp_send_json_success( $results );
    die;

}
add_action( 'wp_ajax_automatorwp_buddyboss_get_groups', 'automatorwp_buddyboss_ajax_get_groups' );

/**
 * Ajax function for selecting profile fields
 *
 * @since 1.0.0
 */
function automatorwp_buddyboss_ajax_get_profile_fields() {
    // Security check, forces to die if not security passed
    check_ajax_referer( 'automatorwp_admin', 'nonce' );

    global $wpdb;

    $results = array();

    // Pull back the search string
    $search = isset( $_REQUEST['q'] ) ? $wpdb->esc_like( $_REQUEST['q'] ) : '';
    $page = isset( $_REQUEST['page'] ) ? absint( $_REQUEST['page'] ) : 1;
    $limit = 20;
    $offset = $limit * ( $page - 1 );
    $prefix = automatorwp_buddyboss_get_table_prefix();

    if( ! empty( $search ) ) {
        $profile_fields = $wpdb->get_results( $wpdb->prepare(
            "SELECT * 
            FROM {$prefix}bp_xprofile_fields 
            WHERE name LIKE %s 
            ORDER BY field_order ASC
            LIMIT {$offset}, {$limit}",
            "%{$search}%"
        ) );

        $count = absint( $wpdb->get_var( $wpdb->prepare(
            "SELECT COUNT(*) FROM {$prefix}bp_xprofile_fields WHERE name LIKE %s",
            "%%{$search}%%"
        ) ) );

    } else {
        $profile_fields = $wpdb->get_results(
            "SELECT * 
            FROM {$prefix}bp_xprofile_fields 
            ORDER BY field_order ASC
            LIMIT {$offset}, {$limit}"
        );

        $count = absint( $wpdb->get_var(
            "SELECT COUNT(*) FROM {$prefix}bp_xprofile_fields"
        ) );
    }

    foreach ( $profile_fields as $profile_field ) {

        // Results should meet Select2 structure
        $results[] = array(
            'id' => $profile_field->id,
            'text' => $profile_field->name,
        );

    }

    // Prepend option none
    $results = automatorwp_ajax_parse_extra_options( $results );

    $response = array(
        'results' => $results,
        'more_results' => $count > $limit && $count > $offset,
    );

    // Return our results
    wp_send_json_success( $response );
    die;

}
add_action( 'wp_ajax_automatorwp_buddyboss_get_profile_fields', 'automatorwp_buddyboss_ajax_get_profile_fields' );

/**
 * Ajax function for selecting group types
 *
 * @since 1.3.2
 */
function automatorwp_buddyboss_ajax_get_group_types() {
    // Security check, forces to die if not security passed
    check_ajax_referer( 'automatorwp_admin', 'nonce' );

    global $wpdb;

    $results = array();

    // Pull back the search string
    $search = isset( $_REQUEST['q'] ) ? $wpdb->esc_like( $_REQUEST['q'] ) : '';
    $page = isset( $_REQUEST['page'] ) ? absint( $_REQUEST['page'] ) : 1;

    if( bp_is_active( 'groups' ) ) {

        // Get the group types
        $types = bp_groups_get_group_types();

        foreach ( $types as $type => $value) {

            // Results should meet Select2 structure
            $results[] = array(
                'id' => $type,
                'text' => $value,
            );

        }

    }

    // Prepend option none
    $results = automatorwp_ajax_parse_extra_options( $results );

    // Return our results
    wp_send_json_success( $results );
    die;

}
add_action( 'wp_ajax_automatorwp_buddyboss_get_group_types', 'automatorwp_buddyboss_ajax_get_group_types' );

/**
 * Ajax function for selecting reactions
 *
 * @since 1.0.0
 */
function automatorwp_buddyboss_ajax_get_reactions() {
    // Security check, forces to die if not security passed
    check_ajax_referer( 'automatorwp_admin', 'nonce' );

    global $wpdb;

    $results = array();

    // Pull back the search string
    $search = isset( $_REQUEST['q'] ) ? $wpdb->esc_like( $_REQUEST['q'] ) : '';
    $page = isset( $_REQUEST['page'] ) ? absint( $_REQUEST['page'] ) : 1;

    // Get the reactions
    $reactions = bb_load_reaction()->bb_get_reactions( 'emotions' );

    foreach ( $reactions as $reaction ) {

        // Results should meet Select2 structure
        $results[] = array(
            'id' => $reaction['id'],
            'text' => $reaction['icon_text'],
        );

    }

    // Prepend option none
    $results = automatorwp_ajax_get_ajax_results_option_none( $results );

    // Return our results
    wp_send_json_success( $results );
    die;

}
add_action( 'wp_ajax_automatorwp_buddyboss_get_reactions', 'automatorwp_buddyboss_ajax_get_reactions' );