<?php
/**
 * Scripts
 *
 * @package     AutomatorWP\Button\Scripts
 * @since       1.0.0
 */
// Exit if accessed directly
if( !defined( 'ABSPATH' ) ) exit;

/**
 * Register frontend scripts
 *
 * @since       1.0.0
 * @return      void
 */
function automatorwp_button_register_scripts() {

    // Use minified libraries if SCRIPT_DEBUG is turned off
    $suffix = ( defined( 'SCRIPT_DEBUG' ) && SCRIPT_DEBUG ) ? '' : '.min';

    // Scripts
    wp_register_script( 'automatorwp-button-js', AUTOMATORWP_BUTTON_URL . 'assets/js/automatorwp-button' . $suffix . '.js', array( 'jquery' ), AUTOMATORWP_BUTTON_VER, true );

}
add_action( 'init', 'automatorwp_button_register_scripts' );

/**
 * Enqueue frontend scripts
 *
 * @since       1.0.0
 * @return      void
 */
function automatorwp_button_enqueue_scripts( $hook = null ) {

    // Scripts
    wp_localize_script( 'automatorwp-button-js', 'automatorwp_button', array(
        'ajaxurl' => esc_url( admin_url( 'admin-ajax.php', 'relative' ) ),
        'nonce' => wp_create_nonce( 'automatorwp_button' )
    ) );

    wp_enqueue_script( 'automatorwp-button-js' );

}
add_action( 'wp_enqueue_scripts', 'automatorwp_button_enqueue_scripts', 100 );