<?php
/**
 * Plugin Name:           AutomatorWP - Calculator
 * Plugin URI:            https://automatorwp.com/add-ons/calculator/
 * Description:           Connect AutomatorWP with Calculator.
 * Version:               1.0.3
 * Author:                AutomatorWP
 * Author URI:            https://automatorwp.com/
 * Text Domain:           automatorwp-calculator
 * Domain Path:           /languages/
 * Requires at least:     4.4
 * Tested up to:          6.6
 * License:               GNU AGPL v3.0 (http://www.gnu.org/licenses/agpl.txt)
 *
 * @package               AutomatorWP\Calculator
 * @author                AutomatorWP
 * @copyright             Copyright (c) AutomatorWP
 */

final class AutomatorWP_Calculator {

    /**
     * @var         AutomatorWP_Calculator $instance The one true AutomatorWP_Calculator
     * @since       1.0.0
     */
    private static $instance;

    /**
     * Get active instance
     *
     * @access      public
     * @since       1.0.0
     * @return      AutomatorWP_Calculator self::$instance The one true AutomatorWP_Calculator
     */
    public static function instance() {
        if( !self::$instance ) {
            self::$instance = new AutomatorWP_Calculator();
            self::$instance->constants();
            self::$instance->includes();
            self::$instance->hooks();            
        }

        return self::$instance;
    }

    /**
     * Setup plugin constants
     *
     * @access      private
     * @since       1.0.0
     * @return      void
     */
    private function constants() {
        // Plugin version
        define( 'AUTOMATORWP_CALCULATOR_VER', '1.0.3' );

        // Plugin file
        define( 'AUTOMATORWP_CALCULATOR_FILE', __FILE__ );

        // Plugin path
        define( 'AUTOMATORWP_CALCULATOR_DIR', plugin_dir_path( __FILE__ ) );

        // Plugin URL
        define( 'AUTOMATORWP_CALCULATOR_URL', plugin_dir_url( __FILE__ ) );
    }

    /**
     * Include plugin files
     *
     * @access      private
     * @since       1.0.0
     * @return      void
     */
    private function includes() {

        if( $this->meets_requirements() ) {

            // Includes
            require_once AUTOMATORWP_CALCULATOR_DIR . 'includes/filters/calculate-filter.php';
            require_once AUTOMATORWP_CALCULATOR_DIR . 'includes/functions.php';
            require_once AUTOMATORWP_CALCULATOR_DIR . 'includes/tags.php';

            // Actions
            require_once AUTOMATORWP_CALCULATOR_DIR . 'includes/actions/calculate-formula.php';
            
        }
    }

    /**
     * Setup plugin hooks
     *
     * @access      private
     * @since       1.0.0
     * @return      void
     */
    private function hooks() {

        add_action( 'automatorwp_init', array( $this, 'register_integration' ) );
        
        

        
    }

    /**
     * Registers this integration
     *
     * @since 1.0.0
     */
    function register_integration() {

        automatorwp_register_integration( 'calculator', array(
            'label' => 'Calculator',
            'icon'  => AUTOMATORWP_CALCULATOR_URL . 'assets/calculator.svg',
        ) );

    }

    /**
     * Check if there are all plugin requirements
     *
     * @since  1.0.0
     *
     * @return bool True if installation meets all requirements
     */
    private function meets_requirements() {

        if ( ! class_exists( 'AutomatorWP' ) ) {
            return false;
        }

        return true;

    }

}

/**
 * The main function responsible for returning the one true AutomatorWP_Calculator instance to functions everywhere
 *
 * @since       1.0.0
 * @return      \AutomatorWP_Calculator The one true AutomatorWP_Calculator
 */
function AutomatorWP_Calculator() {
    return AutomatorWP_Calculator::instance();
}
add_action( 'plugins_loaded', 'AutomatorWP_Calculator' );
