<?php
/**
 * Functions
 *
 * @package     AutomatorWP\Custom_User_Fields\Functions
 * @since       1.0.0
 */
// Exit if accessed directly
if( !defined( 'ABSPATH' ) ) exit;

/**
 * Options callback for select2 fields assigned to fields
 *
 * @since 1.0.0
 *
 * @param stdClass $field
 *
 * @return array
 */
function automatorwp_custom_user_fields_options_cb_field( $field ) {

    // Setup vars
    $value = $field->escaped_value;
    $none_value = 'any';
    $none_label = __( 'any field', 'automatorwp-user-fields' );
    $options = automatorwp_options_cb_none_option( $field, $none_value, $none_label );

    if( ! empty( $value ) ) {
        if( ! is_array( $value ) ) {
            $value = array( $value );
        }

        foreach( $value as $field_id ) {

            // Skip option none
            if( $field_id === $none_value ) {
                continue;
            }

            $options[$field_id] = automatorwp_custom_user_fields_get_field_title( $field_id );
        }
    }

    return $options;

}

/**
 * Get fields
 *
 * @since 1.0.0
 *
 * @return array
 */
function automatorwp_custom_user_fields_get_fields() {

    $custom_fields = array();

    $all_fields = automatorwp_custom_user_fields_get_all();
        
    foreach ( $all_fields as $field ){
    
        $custom_fields[] = array(
            'id' => $field->id,
            'name' => $field->name,
        );
        
    }

    return $custom_fields;
}

/**
 * Get the field title
 *
 * @since 1.0.0
 *
 * @param int $field_id
 *
 * @return string|null
 */
function automatorwp_custom_user_fields_get_field_title( $field_id ) {

    global $wpdb;

    // Empty title if no ID provided
    if( absint( $field_id ) === 0 ) {
        return '';
    }

    // Setup table
    $ct_table = ct_setup_table( 'automatorwp_custom_user_fields' );

    // Search field by ID
    $field_name = $wpdb->get_var( $wpdb->prepare(
        "SELECT cuf.name
        FROM {$ct_table->db->table_name} AS cuf
        WHERE cuf.id = %d",
        absint( $field_id ),
    ) );

    ct_reset_setup_table();

    return $field_name;

}
