<?php
/**
 * Ajax Functions
 *
 * @package     AutomatorWP\eLearnCommerce\Ajax_Functions
 * @since       1.0.0
 */
// Exit if accessed directly
if( !defined( 'ABSPATH' ) ) exit;

/**
 * Ajax function for selecting lessons
 *
 * @since 1.0.0
 */
function automatorwp_elearncommerce_ajax_get_lessons() {
    // Security check, forces to die if not security passed
    check_ajax_referer( 'automatorwp_admin', 'nonce' );

    global $wpdb;

    // Pull back the search string
    $search = isset( $_REQUEST['q'] ) ? $wpdb->esc_like( $_REQUEST['q'] ) : '';
    $table = $wpdb->prefix . ( defined( 'WPEP_DB_TABLE_COURSE_SECTION_LESSON' ) ? WPEP_DB_TABLE_COURSE_SECTION_LESSON : 'wpep_section_lesson' );

    // Get the lessons
    $results = $wpdb->get_results( $wpdb->prepare(
        "SELECT l.id AS id, l.title AS text
        FROM {$table} AS l
        WHERE l.title LIKE %s",
        "%%{$search}%%"
    ) );

    // Prepend option none
    $results = automatorwp_ajax_get_ajax_results_option_none( $results );

    // Return our results
    wp_send_json_success( $results );
    die;

}
add_action( 'wp_ajax_automatorwp_elearncommerce_get_lessons', 'automatorwp_elearncommerce_ajax_get_lessons', 5 );