<?php
/**
 * Functions
 *
 * @package     AutomatorWP\eLearnCommerce\Functions
 * @since       1.0.0
 */
// Exit if accessed directly
if( !defined( 'ABSPATH' ) ) exit;

/**
 * Options callback for select2 fields assigned to lessons
 *
 * @since 1.0.0
 *
 * @param stdClass $field
 *
 * @return array
 */
function automatorwp_elearncommerce_options_cb_lesson( $field ) {

    // Setup vars
    $value = $field->escaped_value;
    $none_value = 'any';
    $none_label = __( 'any lesson', 'automatorwp-pro' );
    $options = automatorwp_options_cb_none_option( $field, $none_value, $none_label );

    if( ! empty( $value ) ) {
        if( ! is_array( $value ) ) {
            $value = array( $value );
        }

        foreach( $value as $lesson_id ) {

            // Skip option none
            if( $lesson_id === $none_value ) {
                continue;
            }

            $options[$lesson_id] = automatorwp_elearncommerce_get_lesson_title( $lesson_id );
        }
    }

    return $options;

}

/**
 * Get the lesson title
 *
 * @since 1.0.0
 *
 * @param int $lesson_id
 *
 * @return string|null
 */
function automatorwp_elearncommerce_get_lesson_title( $lesson_id ) {

    // Empty title if no ID provided
    if( absint( $lesson_id ) === 0 ) {
        return '';
    }

    global $wpdb;

    $table = $wpdb->prefix . ( defined( 'WPEP_DB_TABLE_COURSE_SECTION_LESSON' ) ? WPEP_DB_TABLE_COURSE_SECTION_LESSON : 'wpep_section_lesson' );

    return $wpdb->get_var( $wpdb->prepare(
        "SELECT l.title FROM {$table} AS l WHERE l.id = %d",
        $lesson_id
    ) );

}