<?php
/**
 * Create Event
 *
 * @package     AutomatorWP\Integrations\Eventin\Triggers\Create_Event
 * @author      AutomatorWP <contact@automatorwp.com>, Ruben Garcia <rubengcdev@gmail.com>
 * @since       1.0.0
 */
// Exit if accessed directly
if( !defined( 'ABSPATH' ) ) exit;

class AutomatorWP_Eventin_Create_Event extends AutomatorWP_Integration_Trigger {

    public $integration = 'eventin';
    public $trigger = 'eventin_create_event';

    /**
     * Register the trigger
     *
     * @since 1.0.0
     */
    public function register() {

        automatorwp_register_trigger( $this->trigger, array(
            'integration'       => $this->integration,
            'label'             => __( 'User creates an event', 'automatorwp-pro' ),
            'select_option'     => __( 'User creates an <strong>event</strong>', 'automatorwp-pro' ),
            /* translators: %1$s: Event. %2$s: Number of times. */
            'edit_label'        => sprintf( __( 'User creates an event %1$s time(s)', 'automatorwp-pro' ), '{times}' ),
            'log_label'         => __( 'User creates an event', 'automatorwp-pro' ),
            'action'            => 'eventin_event_created',
            'function'          => array( $this, 'listener' ),
            'priority'          => 10,
            'accepted_args'     => 1,
            'options'           => array(
                'times' => automatorwp_utilities_times_option(),
            ),
            'tags' => array_merge(
                automatorwp_utilities_post_tags(),
                automatorwp_utilities_times_tag()
            )
        ) );

    }

    /**
     * Trigger listener
     *
     * @since 1.0.0
     *
     * @param Event_Model       $event    $event data
     */
    public function listener( $event ) {
    
        $user_id = get_current_user_id( );

        // Bail if user is not logged
        if ( $user_id === 0 ){
            return;
        }

        // Trigger create event
        automatorwp_trigger_event( array(
            'trigger'   => $this->trigger,
            'user_id'   => $user_id,
            'post_id'   => $event->id,
        ) );
       
    }

}

new AutomatorWP_Eventin_Create_Event();