<?php
/**
 * Ajax Functions
 *
 * @package     AutomatorWP\Integrations\Facebook\Ajax_Functions
 * @since       1.0.0
 */
// Exit if accessed directly
if( !defined( 'ABSPATH' ) ) exit;


/**
 * AJAX handler for the authorize action
 *
 * @since 1.0.0
 */
function automatorwp_facebook_ajax_authorize() {
    // Security check
    check_ajax_referer( 'automatorwp_admin', 'nonce' );

    $prefix = 'automatorwp_facebook_';

    $application_id = sanitize_text_field( $_POST['application_id'] );
    $application_secret = sanitize_text_field( $_POST['application_secret'] );
   
    // Check parameters given
    if( empty( $application_id ) || empty( $application_secret ) ) {
        wp_send_json_error( array( 'message' => __( 'All fields are required to connect with Facebook', 'automatorwp-pro' ) ) );
    }

    $settings = get_option( 'automatorwp_settings' );

    // Save client id and secret
    $settings[$prefix . 'application_id'] = $application_id;
    $settings[$prefix . 'application_secret'] = $application_secret;

    // Update settings
    update_option( 'automatorwp_settings', $settings );

    $api_version = automatorwp_facebook_api_version();

    // Allows read/write access to the user's sheets and their properties.
    $scope = urlencode( 'pages_show_list,pages_read_engagement,pages_manage_metadata,pages_read_user_content,pages_manage_posts' );

    $admin_url = str_replace( 'http://', 'https://', get_admin_url() )  . 'admin.php?page=automatorwp_settings&tab=opt-tab-facebook';

    $redirect_url = 'https://www.facebook.com/' . $api_version . '/dialog/oauth?client_id=' . $application_id .'&redirect_uri=' . urlencode( $admin_url ) . '&scope=' . $scope;
    
    // Return the redirect URL
    wp_send_json_success( array(
        'message' => __( 'Settings saved successfully, redirecting to Facebook...', 'automatorwp-pro' ),
        'redirect_url' => $redirect_url
    ) );

}
add_action( 'wp_ajax_automatorwp_facebook_authorize',  'automatorwp_facebook_ajax_authorize' );


/**
 * Ajax function for selecting pages
 *
 * @since 1.0.0
 */
function automatorwp_facebook_ajax_get_pages() {
    // Security check, forces to die if not security passed
    check_ajax_referer( 'automatorwp_admin', 'nonce' );

    global $wpdb;

    // Pull back the search string
    $search = isset( $_REQUEST['q'] ) ? $wpdb->esc_like( $_REQUEST['q'] ) : '';

    $pages = automatorwp_facebook_get_pages();
    $results = array();

    // Parse pages results to match select2 results
    foreach ( $pages as $page ) {

        if( ! empty( $search ) ) {
            if( strpos( strtolower( $page['name'] ), strtolower( $search ) ) === false ) {
                continue;
            }
        }

        $results[] = array(
            'id'   => $page['id'],
            'text' => $page['name']
        );
    }

    // Prepend option none
    $results = automatorwp_ajax_parse_extra_options( $results );

    // Return our results
    wp_send_json_success( $results );
    die;

}
add_action( 'wp_ajax_automatorwp_facebook_get_pages', 'automatorwp_facebook_ajax_get_pages' );

/**
 * Ajax function for selecting groups
 *
 * @since 1.0.0
 */
function automatorwp_facebook_ajax_get_groups() {
    // Security check, forces to die if not security passed
    check_ajax_referer( 'automatorwp_admin', 'nonce' );

    global $wpdb;

    // Pull back the search string
    $search = isset( $_REQUEST['q'] ) ? $wpdb->esc_like( $_REQUEST['q'] ) : '';

    $groups = automatorwp_facebook_get_groups();
    $results = array();

    // Parse pages results to match select2 results
    foreach ( $groups as $group ) {

        if( ! empty( $search ) ) {
            if( strpos( strtolower( $group['name'] ), strtolower( $search ) ) === false ) {
                continue;
            }
        }

        $results[] = array(
            'id'   => $group['id'],
            'text' => $group['name']
        );
    }

    // Prepend option none
    $results = automatorwp_ajax_parse_extra_options( $results );

    // Return our results
    wp_send_json_success( $results );
    die;

}
add_action( 'wp_ajax_automatorwp_facebook_get_groups', 'automatorwp_facebook_ajax_get_groups' );
