<?php
/**
 * Scripts
 *
 * @package     AutomatorWP\Integrations\Facebook\Scripts
 * @author      AutomatorWP <contact@automatorwp.com>, Ruben Garcia <rubengcdev@gmail.com>
 * @since       1.0.0
 */
// Exit if accessed directly
if( !defined( 'ABSPATH' ) ) exit;

/**
 * Register admin scripts
 *
 * @since       1.0.0
 * @return      void
 */
function automatorwp_facebook_admin_register_scripts() {

    // Use minified libraries if SCRIPT_DEBUG is turned off
    $suffix = ( defined( 'SCRIPT_DEBUG' ) && SCRIPT_DEBUG ) ? '' : '.min';

    // Stylesheets
    wp_register_style( 'automatorwp-facebook-css', AUTOMATORWP_FACEBOOK_URL . 'assets/css/automatorwp-facebook' . $suffix . '.css', array(), AUTOMATORWP_FACEBOOK_VER, 'all' );

    // Scripts
    wp_register_script( 'automatorwp-facebook-js', AUTOMATORWP_FACEBOOK_URL . 'assets/js/automatorwp-facebook' . $suffix . '.js', array( 'jquery' ), AUTOMATORWP_FACEBOOK_VER, true );

}
add_action( 'admin_init', 'automatorwp_facebook_admin_register_scripts' );

/**
 * Enqueue admin scripts
 *
 * @since       1.0.0
 * @return      void
 */
function automatorwp_facebook_admin_enqueue_scripts( $hook ) {

    // Stylesheets
    wp_enqueue_style( 'automatorwp-facebook-css' );

    wp_localize_script( 'automatorwp-facebook-js', 'automatorwp_facebook', array(
        'nonce' => automatorwp_get_admin_nonce(),
    ) );

    wp_enqueue_script( 'automatorwp-facebook-js' );

}
add_action( 'admin_enqueue_scripts', 'automatorwp_facebook_admin_enqueue_scripts', 100 );