<?php
/**
 * Create Contact
 *
 * @package     AutomatorWP\Integrations\FluentCRM\Actions\Create_Contact
 * @author      AutomatorWP <contact@automatorwp.com>, Ruben Garcia <rubengcdev@gmail.com>
 * @since       1.0.0
 */
// Exit if accessed directly

if( !defined( 'ABSPATH' ) ) exit;

class AutomatorWP_FluentCRM_Create_Contact extends AutomatorWP_Integration_Action {

    public $integration = 'fluentcrm';
    public $action = 'fluentcrm_create_contact';

    /**
     * Register the trigger
     *
     * @since 1.0.0
     */
    public function register() {

        automatorwp_register_action( $this->action, array(
            'integration'       => $this->integration,
            'label'             => __( 'Create a contact', 'automatorwp-pro' ),
            'select_option'     => __( 'Create a <strong>contact</strong>', 'automatorwp-pro' ),
            /* translators: %1$s: Contact. */
            'edit_label'        => sprintf( __( 'Create a %1$s', 'automatorwp-pro' ), '{contact}' ),
            /* translators: %1$s: Contact. */
            'log_label'         => sprintf( __( 'Create a %1$s', 'automatorwp-pro' ), '{contact}' ),
            'options'           => array(
                'contact' => array(
                    'default' => __( 'contact', 'automatorwp-pro' ),
                    'fields' => array(
                        'prefix' => array(
                            'name' => __( 'Prefix:', 'automatorwp-pro' ),
                            'type' => 'select',
                            'options' => array(
                                'Mr'    => __( 'Mr', 'automatorwp-pro' ),
                                'Mrs'   => __( 'Mrs', 'automatorwp-pro' ),
                                'Ms'    => __( 'Ms', 'automatorwp-pro' ),
                            ),
                            'default' => 'Mr'
                        ),
                        'first_name' => array(
                            'name' => __( 'First Name:', 'automatorwp-pro' ),
                            'type' => 'text',
                        ),
                        'last_name' => array(
                            'name' => __( 'Last Name:', 'automatorwp-pro' ),
                            'type' => 'text',
                        ),
                        'email' => array(
                            'name' => __( 'Email:', 'automatorwp-pro' ),
                            'type' => 'text',
                            'required' => true,
                        ),
                        'phone' => array(
                            'name' => __( 'Phone:', 'automatorwp-pro' ),
                            'type' => 'text',
                        ),
                        'date_of_birth' => array(
                            'name' => __( 'Date of birth:', 'automatorwp-pro' ),
                            'type' => 'text',
                            'attributes' => array(
                                'placeholder' => 'YYYY-MM-DD'
                            )
                        ),
                        'address_line_1' => array(
                            'name' => __( 'Address Line 1:', 'automatorwp-pro' ),
                            'type' => 'text',
                        ),
                        'address_line_2' => array(
                            'name' => __( 'Address Line 2:', 'automatorwp-pro' ),
                            'type' => 'text',
                        ),
                        'city' => array(
                            'name' => __( 'City:', 'automatorwp-pro' ),
                            'type' => 'text',
                        ),
                        'state' => array(
                            'name' => __( 'State:', 'automatorwp-pro' ),
                            'type' => 'text',
                        ),
                        'postal_code' => array(
                            'name' => __( 'Postal Code:', 'automatorwp-pro' ),
                            'type' => 'text',
                        ),
                        'country' => automatorwp_utilities_ajax_selector_field( array(
                            'name' => __( 'Country:', 'automatorwp-pro' ),
                            'option_custom' => true,
                            'action_cb'         => 'automatorwp_fluentcrm_get_countries',
                            'options_cb'        => 'automatorwp_fluentcrm_options_cb_country',
                            'placeholder'       => __( 'Select a country', 'automatorwp-pro' ),
                        ) ),
                        'country_custom' => automatorwp_utilities_custom_field( array(
                            'option_custom_desc'    => __( 'Country Code', 'automatorwp-pro' ),
                        ) ),
                        'status' => array(
                            'name' => __( 'Status:', 'automatorwp-pro' ),
                            'type' => 'select',
                            'options' => array(
                                'subscribed'    => __( 'Subscribed', 'automatorwp-pro' ),
                                'pending'       => __( 'Pending', 'automatorwp-pro' ),
                                'unsubscribed'  => __( 'Unsubscribed', 'automatorwp-pro' ),
                                'bounced'       => __( 'Bounced', 'automatorwp-pro' ),
                                'complained'    => __( 'Complained', 'automatorwp-pro' ),
                            ),
                            'default' => 'subscribed'
                        ),
                        'custom_fields' => array(
                            'name' => __( 'Custom Fields:', 'automatorwp-pro' ),
                            'desc' => __( 'Custom fields.', 'automatorwp-pro' ),
                            'type' => 'group',
                            'classes' => 'automatorwp-fields-table',
                            'options'     => array(
                                'add_button'        => __( 'Add custom field', 'automatorwp-pro' ),
                                'remove_button'     => '<span class="dashicons dashicons-no-alt"></span>',
                                ),
                            'fields' => array(
                                'key' => array(
                                    'name' => __( 'Key:', 'automatorwp-webhooks' ),
                                    'type' => 'select',
                                    'classes' => 'automatorwp-selector',
                                    'options_cb' => 'automatorwp_fluentcrm_options_cb_custom_fields',
                                    'default' => ''
                                ),
                                'value' => array(
                                    'name' => __( 'Value:', 'automatorwp-webhooks' ),
                                    'type' => 'text',
                                    'default' => ''
                                ),
                            ),
                        ),
                    )
                ),
            ),
        ) );

    }

    /**
     * Action execution function
     *
     * @since 1.0.0
     *
     * @param stdClass  $action             The action object
     * @param int       $user_id            The user ID
     * @param array     $action_options     The action's stored options (with tags already passed)
     * @param stdClass  $automation         The action's automation object
     */
    public function execute( $action, $user_id, $action_options, $automation ) {

        $subscriber_data = wp_parse_args( $action_options, array(
            'prefix' => 'Mr',
            'first_name' => '',
            'last_name' => '',
            'email' => '',
            'phone' => '',
            'date_of_birth' => '',
            'address_line_1' => '',
            'address_line_2' => '',
            'city' => '',
            'state' => '',
            'postal_code' => '',
            'country' => '',
            'status' => 'subscribed',
        ) );

        $custom_fields = $action_options['custom_fields'];
        
        if ( is_array( $custom_fields ) ) {
            
            foreach( $custom_fields as $key => $custom_field ) {
                $subscriber_data['custom_values'][$custom_field['key']] = $custom_field['value'];
            }
        }

        $subscriber = new FluentCrm\App\Models\Subscriber();

        // Update or create the new subscriber
        $subscriber->updateOrCreate( $subscriber_data, true );

    }

}

new AutomatorWP_FluentCRM_Create_Contact();