<?php
/**
 * Plugin Name:           AutomatorWP - GamiPress
 * Plugin URI:            https://automatorwp.com/add-ons/gamipress/
 * Description:           Connect AutomatorWP with GamiPress.
 * Version:               1.1.4
 * Author:                AutomatorWP
 * Author URI:            https://automatorwp.com/
 * Text Domain:           automatorwp-gamipress
 * Domain Path:           /languages/
 * Requires at least:     4.4
 * Tested up to:          6.6
 * License:               GNU AGPL v3.0 (http://www.gnu.org/licenses/agpl.txt)
 *
 * @package               AutomatorWP\GamiPress
 * @author                AutomatorWP
 * @copyright             Copyright (c) AutomatorWP
 */

final class AutomatorWP_GamiPress {

    /**
     * @var         AutomatorWP_GamiPress $instance The one true AutomatorWP_GamiPress
     * @since       1.0.0
     */
    private static $instance;

    /**
     * Get active instance
     *
     * @access      public
     * @since       1.0.0
     * @return      AutomatorWP_GamiPress self::$instance The one true AutomatorWP_GamiPress
     */
    public static function instance() {
        if( !self::$instance ) {
            self::$instance = new AutomatorWP_GamiPress();
            self::$instance->constants();
            self::$instance->includes();
            self::$instance->hooks();            
        }

        return self::$instance;
    }

    /**
     * Setup plugin constants
     *
     * @access      private
     * @since       1.0.0
     * @return      void
     */
    private function constants() {
        // Plugin version
        define( 'AUTOMATORWP_GAMIPRESS_VER', '1.1.4' );

        // Plugin file
        define( 'AUTOMATORWP_GAMIPRESS_FILE', __FILE__ );

        // Plugin path
        define( 'AUTOMATORWP_GAMIPRESS_DIR', plugin_dir_path( __FILE__ ) );

        // Plugin URL
        define( 'AUTOMATORWP_GAMIPRESS_URL', plugin_dir_url( __FILE__ ) );
    }

    /**
     * Include plugin files
     *
     * @access      private
     * @since       1.0.0
     * @return      void
     */
    private function includes() {

        if( $this->meets_requirements() ) {

            // Includes
            require_once AUTOMATORWP_GAMIPRESS_DIR . 'includes/functions.php';

            // Triggers
            // Points
            require_once AUTOMATORWP_GAMIPRESS_DIR . 'includes/triggers/earn-points.php';
            require_once AUTOMATORWP_GAMIPRESS_DIR . 'includes/triggers/points-balance.php';
            // Achievements
            require_once AUTOMATORWP_GAMIPRESS_DIR . 'includes/triggers/view-achievement.php';
            require_once AUTOMATORWP_GAMIPRESS_DIR . 'includes/triggers/earn-achievement.php';
            require_once AUTOMATORWP_GAMIPRESS_DIR . 'includes/triggers/earn-achievement-type.php';
            require_once AUTOMATORWP_GAMIPRESS_DIR . 'includes/triggers/achievement-revoked.php';
            require_once AUTOMATORWP_GAMIPRESS_DIR . 'includes/triggers/achievement-type-revoked.php';
            // Ranks
            require_once AUTOMATORWP_GAMIPRESS_DIR . 'includes/triggers/view-rank.php';
            require_once AUTOMATORWP_GAMIPRESS_DIR . 'includes/triggers/reach-rank.php';
            require_once AUTOMATORWP_GAMIPRESS_DIR . 'includes/triggers/reach-rank-type.php';
            require_once AUTOMATORWP_GAMIPRESS_DIR . 'includes/triggers/rank-revoked.php';
            require_once AUTOMATORWP_GAMIPRESS_DIR . 'includes/triggers/rank-type-revoked.php';
            // GamiPress Coupons
            require_once AUTOMATORWP_GAMIPRESS_DIR . 'includes/triggers/redeem-coupon.php';
            // GamiPress Expirations
            require_once AUTOMATORWP_GAMIPRESS_DIR . 'includes/triggers/achievement-expires.php';
            require_once AUTOMATORWP_GAMIPRESS_DIR . 'includes/triggers/achievement-type-expires.php';
            require_once AUTOMATORWP_GAMIPRESS_DIR . 'includes/triggers/rank-expires.php';
            require_once AUTOMATORWP_GAMIPRESS_DIR . 'includes/triggers/rank-type-expires.php';

            // Actions
            require_once AUTOMATORWP_GAMIPRESS_DIR . 'includes/actions/user-points.php';
            require_once AUTOMATORWP_GAMIPRESS_DIR . 'includes/actions/user-achievement.php';
            require_once AUTOMATORWP_GAMIPRESS_DIR . 'includes/actions/user-rank.php';

            // Filters
            require_once AUTOMATORWP_GAMIPRESS_DIR . 'includes/filters/user-points.php';
            require_once AUTOMATORWP_GAMIPRESS_DIR . 'includes/filters/user-achievement.php';
            require_once AUTOMATORWP_GAMIPRESS_DIR . 'includes/filters/user-rank.php';

        }
    }

    /**
     * Setup plugin hooks
     *
     * @access      private
     * @since       1.0.0
     * @return      void
     */
    private function hooks() {

        add_action( 'automatorwp_init', array( $this, 'register_integration' ) );
        
        // Setup our activation and deactivation hooks
        register_activation_hook( __FILE__, array( $this, 'activate' ) );
        register_deactivation_hook( __FILE__, array( $this, 'deactivate' ) );
        

        
    }

    /**
     * Registers this integration
     *
     * @since 1.0.0
     */
    function register_integration() {

        automatorwp_register_integration( 'gamipress', array(
            'label' => 'GamiPress',
            'icon'  => AUTOMATORWP_GAMIPRESS_URL . 'assets/gamipress.svg',
        ) );

    }

    /**
     * Activation hook for the plugin.
     *
     * @since  1.0.0
     */
    function activate() {

        if( $this->meets_requirements() ) {

        }

    }

    /**
     * Deactivation hook for the plugin.
     *
     * @since  1.0.0
     */
    function deactivate() {

    }

    /**
     * Check if there are all plugin requirements
     *
     * @since  1.0.0
     *
     * @return bool True if installation meets all requirements
     */
    private function meets_requirements() {

        if ( ! class_exists( 'AutomatorWP' ) ) {
            return false;
        }

        if ( ! class_exists( 'GamiPress' ) ) {
            return false;
        }

        return true;

    }

}

/**
 * The main function responsible for returning the one true AutomatorWP_GamiPress instance to functions everywhere
 *
 * @since       1.0.0
 * @return      \AutomatorWP_GamiPress The one true AutomatorWP_GamiPress
 */
function AutomatorWP_GamiPress() {
    return AutomatorWP_GamiPress::instance();
}
add_action( 'plugins_loaded', 'AutomatorWP_GamiPress' );
