<?php
/**
 * Create User Note
 *
 * @package     AutomatorWP\Integrations\Groundhogg\Actions\Create_User_Note
 * @author      AutomatorWP <contact@automatorwp.com>, Ruben Garcia <rubengcdev@gmail.com>
 * @since       1.0.5
 */
// Exit if accessed directly
if( !defined( 'ABSPATH' ) ) exit;

class AutomatorWP_Groundhogg_Create_User_Note extends AutomatorWP_Integration_Action {

    public $integration = 'groundhogg';
    public $action = 'groundhogg_create_user_note';

    /**
     * Register the trigger
     *
     * @since 1.0.0
     */
    public function register() {

        automatorwp_register_action( $this->action, array(
            'integration'       => $this->integration,
            'label'             => __( 'Create note and assign to user', 'automatorwp-pro' ),
            'select_option'     => __( 'Create <strong>note</strong> and assign to <strong>user</strong>', 'automatorwp-pro' ),
            /* %1$s: Note. */
            'edit_label'        => sprintf( __( 'Create %1$s and assign to user', 'automatorwp-pro' ), '{note}' ),
            /* %1$s: Note. */
            'log_label'         => sprintf( __( 'Create %1$s and assign to user', 'automatorwp-pro' ), '{note}' ),
            'options'           => array(
                'note' => array(
                    'default' => __( 'Note', 'automatorwp-pro' ),
                    'fields' => array(
                        'note' => array(
                            'name' => __( 'Note:', 'automatorwp-pro' ),
                            'desc' => __( 'The note to add', 'automatorwp-pro' ),
                            'type' => 'wysiwyg',
                            'required'  => true,
                            'default' => ''
                        ),
                    ) )
            ),
        ) );

    }

    /**
     * Action execution function
     *
     * @since 1.0.0
     *
     * @param stdClass  $action             The action object
     * @param int       $user_id            The user ID
     * @param array     $action_options     The action's stored options (with tags already passed)
     * @param stdClass  $automation         The action's automation object
     */
    public function execute( $action, $user_id, $action_options, $automation ) {

        // Shorthand
        $note = $action_options['note'];

        // Bail if empty tag to assign
        if( empty( $note ) ) {
            return;
        }

        $note = wp_kses_post( $note );

        $contact = new Groundhogg\Contact( $user_id, true );

        if( ! $contact ) {
            return;
        }

        // Add note to the user
        $contact->add_note( $note );

    }

}

new AutomatorWP_Groundhogg_Create_User_Note();