<?php
/**
 * Create User Tag
 *
 * @package     AutomatorWP\Integrations\Groundhogg\Actions\Create_User_Tag
 * @author      AutomatorWP <contact@automatorwp.com>, Ruben Garcia <rubengcdev@gmail.com>
 * @since       1.0.5
 */
// Exit if accessed directly
if( !defined( 'ABSPATH' ) ) exit;

class AutomatorWP_Groundhogg_Create_User_Tag extends AutomatorWP_Integration_Action {

    public $integration = 'groundhogg';
    public $action = 'groundhogg_create_user_tag';

    /**
     * Register the trigger
     *
     * @since 1.0.0
     */
    public function register() {

        automatorwp_register_action( $this->action, array(
            'integration'       => $this->integration,
            'label'             => __( 'Create tag and assign to user', 'automatorwp-pro' ),
            'select_option'     => __( 'Create <strong>tag</strong> and assign to <strong>user</strong>', 'automatorwp-pro' ),
            /* %1$s: Tag. */
            'edit_label'        => sprintf( __( 'Create %1$s and assign to user', 'automatorwp-pro' ), '{tag}' ),
            /* %1$s: Tag. */
            'log_label'         => sprintf( __( 'Create %1$s and assign to user', 'automatorwp-pro' ), '{tag}' ),
            'options'           => array(
                'tag' => array(
                    'from' => 'tag',
                    'default' => __( 'tag', 'automatorwp-pro' ),
                    'fields' => array(
                        'tag' => array(
                            'name' => __( 'Tag:', 'automatorwp-pro' ),
                            'desc' => __( 'The tag name', 'automatorwp-pro' ),
                            'type' => 'text',
                            'required'  => true,
                            'default' => ''
                        ),
                    ) )
            ),
        ) );

    }

    /**
     * Action execution function
     *
     * @since 1.0.0
     *
     * @param stdClass  $action             The action object
     * @param int       $user_id            The user ID
     * @param array     $action_options     The action's stored options (with tags already passed)
     * @param stdClass  $automation         The action's automation object
     */
    public function execute( $action, $user_id, $action_options, $automation ) {

        global $wpdb;

        // Shorthand
        $tag_name = $action_options['tag'];

        // Bail if empty tag to assign
        if( empty( $tag_name ) ) {
            return;
        }

        $tag_slug = sanitize_title( $tag_name, 'display' );

        // To check if the tag exists by slug
        $tag = $wpdb->get_row( $wpdb->prepare(
            "SELECT * FROM {$wpdb->prefix}gh_tags WHERE tag_slug = %s",
            $tag_slug
        ) );

        if ( ! $tag ){
            $tag_id = Groundhogg\Plugin::$instance->dbs->get_db( 'tags' )->add( array(
                'tag_name'        => $tag_name
            ) );
        } else{
            $tag_id = $tag->tag_id;
        }

        $contact = new Groundhogg\Contact( $user_id, true );

        if( ! $contact ) {
            return;
        }

        // Add tag to the user
        $contact->add_tag( $tag_id );

    }

}

new AutomatorWP_Groundhogg_Create_User_Tag();