<?php
/**
 * Plugin Name:           AutomatorWP - Kali Forms
 * Plugin URI:            https://automatorwp.com/add-ons/kali-forms/
 * Description:           Connect AutomatorWP with Gravity Forms.
 * Version:               1.0.0
 * Author:                AutomatorWP
 * Author URI:            https://automatorwp.com/
 * Text Domain:           automatorwp-kali-forms
 * Domain Path:           /languages/
 * Requires at least:     4.4
 * Tested up to:          6.6
 * License:               GNU AGPL v3.0 (http://www.gnu.org/licenses/agpl.txt)
 *
 * @package               AutomatorWP\Kali_Forms
 * @author                AutomatorWP
 * @copyright             Copyright (c) AutomatorWP
 */

final class AutomatorWP_Kali_Forms {

    /**
     * @var         AutomatorWP_Kali_Forms $instance The one true AutomatorWP_Kali_Forms
     * @since       1.0.0
     */
    private static $instance;

    /**
     * Get active instance
     *
     * @access      public
     * @since       1.0.0
     * @return      AutomatorWP_Kali_Forms self::$instance The one true AutomatorWP_Kali_Forms
     */
    public static function instance() {
        if( !self::$instance ) {
            self::$instance = new AutomatorWP_Kali_Forms();
            self::$instance->constants();
            self::$instance->includes();
            self::$instance->hooks();            
        }

        return self::$instance;
    }

    /**
     * Setup plugin constants
     *
     * @access      private
     * @since       1.0.0
     * @return      void
     */
    private function constants() {
        // Plugin version
        define( 'AUTOMATORWP_KALI_FORMS_VER', '1.0.0' );

        // Plugin file
        define( 'AUTOMATORWP_KALI_FORMS_FILE', __FILE__ );

        // Plugin path
        define( 'AUTOMATORWP_KALI_FORMS_DIR', plugin_dir_path( __FILE__ ) );

        // Plugin URL
        define( 'AUTOMATORWP_KALI_FORMS_URL', plugin_dir_url( __FILE__ ) );
    }

    /**
     * Include plugin files
     *
     * @access      private
     * @since       1.0.0
     * @return      void
     */
    private function includes() {

        if( $this->meets_requirements() ) {

            // Includes
            require_once AUTOMATORWP_KALI_FORMS_DIR . 'includes/functions.php';

            // Triggers
            require_once AUTOMATORWP_KALI_FORMS_DIR . 'includes/triggers/submit-form.php';
            require_once AUTOMATORWP_KALI_FORMS_DIR . 'includes/triggers/submit-field-value.php';
            
            // Anonymous Triggers
            require_once AUTOMATORWP_KALI_FORMS_DIR . 'includes/triggers/anonymous-submit-form.php';
            require_once AUTOMATORWP_KALI_FORMS_DIR . 'includes/triggers/anonymous-submit-field-value.php';

        }
    }

    /**
     * Setup plugin hooks
     *
     * @access      private
     * @since       1.0.0
     * @return      void
     */
    private function hooks() {

        add_action( 'automatorwp_init', array( $this, 'register_integration' ) );
        
        

        
    }

    /**
     * Registers this integration
     *
     * @since 1.0.0
     */
    function register_integration() {

        automatorwp_register_integration( 'kali_forms', array(
            'label' => 'Kali Forms',
            'icon'  => AUTOMATORWP_KALI_FORMS_URL . 'assets/kali-forms.svg',
        ) );

    }

    /**
     * Activation hook for the plugin.
     *
     * @since  1.0.0
     */
    function activate() {

        if( $this->meets_requirements() ) {

        }

    }

    /**
     * Deactivation hook for the plugin.
     *
     * @since  1.0.0
     */
    function deactivate() {

    }

    /**
     * Check if there are all plugin requirements
     *
     * @since  1.0.0
     *
     * @return bool True if installation meets all requirements
     */
    private function meets_requirements() {

        if ( ! class_exists( 'AutomatorWP' ) ) {
            return false;
        }

        if ( ! class_exists( 'KaliForms\Inc\KaliForms' ) ) {
            return false;
        }

        return true;

    }

}

/**
 * The main function responsible for returning the one true AutomatorWP_Kali_Forms instance to functions everywhere
 *
 * @since       1.0.0
 * @return      \AutomatorWP_Kali_Forms The one true AutomatorWP_Kali_Forms
 */
function AutomatorWP_Kali_Forms() {
    return AutomatorWP_Kali_Forms::instance();
}
add_action( 'plugins_loaded', 'AutomatorWP_Kali_Forms' );
