<?php
/**
 * Approve Assignment
 *
 * @package     AutomatorWP\Integrations\LearnDash\Triggers\Approve_Assignment
 * @author      AutomatorWP <contact@automatorwp.com>, Ruben Garcia <rubengcdev@gmail.com>
 * @since       1.0.0
 */
// Exit if accessed directly
if( !defined( 'ABSPATH' ) ) exit;

class AutomatorWP_LearnDash_Approve_Assignment extends AutomatorWP_Integration_Trigger {

    public $integration = 'learndash';
    public $trigger = 'learndash_approve_assignment';

    /**
     * Register the trigger
     *
     * @since 1.0.0
     */
    public function register() {

        automatorwp_register_trigger( $this->trigger, array(
            'integration'       => $this->integration,
            'label'             => __( 'User approves an assignment', 'automatorwp-pro' ),
            'select_option'     => __( 'User approves <strong>an assignment</strong>', 'automatorwp-pro' ),
            /* translators: %1$s: Number of times. */
            'edit_label'        => sprintf( __( 'User approves an assignment %1$s time(s)', 'automatorwp-pro' ), '{times}' ),
            'log_label'         => __( 'User approves an assignment', 'automatorwp-pro' ),
            'action'            => 'learndash_assignment_approved',
            'function'          => array( $this, 'listener' ),
            'priority'          => 10,
            'accepted_args'     => 1,
            'options'           => array(
                'times' => automatorwp_utilities_times_option(),
            ),
            'tags' => array_merge(
                automatorwp_utilities_post_tags(),
                automatorwp_utilities_times_tag()
            )
        ) );

    }

    /**
     * Trigger listener
     *
     * @since 1.0.0
     *
     * @param int 		$assignment_id 	    The assignment post ID
     */
    public function listener( $assignment_id ) {

        $assignment = get_post( $assignment_id );

        // Bail if assignment doesn't exists
        if( ! $assignment ) {
            return;
        }

        $user_id = $assignment->post_author;
        $lesson_id = get_post_meta( $assignment_id, 'lesson_id', true );
        $course_id = get_post_meta( $assignment_id, 'course_id', true );

        automatorwp_trigger_event( array(
            'trigger'   => $this->trigger,
            'user_id'   => $user_id,
            'post_id'   => $assignment_id,
            'lesson_id' => $lesson_id,
            'course_id' => $course_id,
        ) );

    }

    /**
     * User deserves check
     *
     * @since 1.0.0
     *
     * @param bool      $deserves_trigger   True if user deserves trigger, false otherwise
     * @param stdClass  $trigger            The trigger object
     * @param int       $user_id            The user ID
     * @param array     $event              Event information
     * @param array     $trigger_options    The trigger's stored options
     * @param stdClass  $automation         The trigger's automation object
     *
     * @return bool                          True if user deserves trigger, false otherwise
     */
    public function user_deserves_trigger( $deserves_trigger, $trigger, $user_id, $event, $trigger_options, $automation ) {

        // Don't deserve if post is not received
        if( ! isset( $event['post_id'] ) ) {
            return false;
        }

        return $deserves_trigger;

    }

}

new AutomatorWP_LearnDash_Approve_Assignment();