<?php
/**
 * Complete Assignment
 *
 * @package     AutomatorWP\Integrations\LifterLMS\Triggers\Complete_Assignment
 * @author      AutomatorWP <contact@automatorwp.com>, Ruben Garcia <rubengcdev@gmail.com>
 * @since       1.0.0
 */
// Exit if accessed directly
if( !defined( 'ABSPATH' ) ) exit;

class AutomatorWP_LifterLMS_Complete_Assignment extends AutomatorWP_Integration_Trigger {

    public $integration = 'lifterlms';
    public $trigger = 'lifterlms_complete_assignment';

    /**
     * Register the trigger
     *
     * @since 1.0.0
     */
    public function register() {

        automatorwp_register_trigger( $this->trigger, array(
            'integration'       => $this->integration,
            'label'             => __( 'User passes or fails an assignment', 'automatorwp-pro' ),
            'select_option'     => __( 'User <strong>passes or fails</strong> an assignment', 'automatorwp-pro' ),
            /* translators: %1$s: Operation (attempts, passes or fails). %2$s: Post title. %3$s: Number of times. */
            'edit_label'        => sprintf( __( 'User %1$s %2$s %3$s time(s)', 'automatorwp-pro' ), '{operation}', '{post}', '{times}' ),
            /* translators: %1$s: Operation (attempts, passes or fails). %2$s: Post title. */
            'log_label'         => sprintf( __( 'User %1$s %2$s', 'automatorwp-pro' ), '{operation}', '{post}' ),
            'action'            => 'llms_assignment_graded',
            'function'          => array( $this, 'listener' ),
            'priority'          => 10,
            'accepted_args'     => 1,
            'options'           => array(
                'operation' => array(
                    'from' => 'operation',
                    'fields' => array(
                        'operation' => array(
                            'name' => __( 'Operation:', 'automatorwp-pro' ),
                            'type' => 'select',
                            'options' => array(
                                'pass'    => __( 'passes', 'automatorwp-pro' ),
                                'fail'    => __( 'fails', 'automatorwp-pro' ),
                            ),
                            'default' => 'pass'
                        ),
                    )
                ),
                'post' => automatorwp_utilities_post_option( array(
                    'name' => __( 'Assignment:', 'automatorwp-pro' ),
                    'option_none_label' => __( 'any assignment', 'automatorwp-pro' ),
                    'post_type' => 'llms_assignment'
                ) ),
                'times' => automatorwp_utilities_times_option(),
            ),
            'tags' => array_merge(
                automatorwp_utilities_post_tags(),
                automatorwp_utilities_times_tag()
            )
        ) );

    }

    /**
     * Trigger listener
     *
     * @since 1.0.0
     *
     * @param LLMS_Assignment_Submission $submission
     */
    public function listener( $submission ) {

        $assignment = $submission->get_assignment();
        $user_id = $submission->get( 'user_id' );
        $status = $submission->get( 'status' );

        automatorwp_trigger_event( array(
            'trigger'   => $this->trigger,
            'user_id'   => $user_id,
            'post_id'   => $assignment->id,
            'status'    => $status,
        ) );

    }

    /**
     * User deserves check
     *
     * @since 1.0.0
     *
     * @param bool      $deserves_trigger   True if user deserves trigger, false otherwise
     * @param stdClass  $trigger            The trigger object
     * @param int       $user_id            The user ID
     * @param array     $event              Event information
     * @param array     $trigger_options    The trigger's stored options
     * @param stdClass  $automation         The trigger's automation object
     *
     * @return bool                          True if user deserves trigger, false otherwise
     */
    public function user_deserves_trigger( $deserves_trigger, $trigger, $user_id, $event, $trigger_options, $automation ) {

        // Shorthand
        $operation = $trigger_options['operation'];

        // Ensure operation default value
        if( empty( $operation ) ) {
            $operation = 'pass';
        }

        // Don't deserve if post is not received
        if( ! isset( $event['post_id'] ) && ! isset( $event['status'] ) ) {
            return false;
        }

        // Don't deserve if post doesn't match with the trigger option
        if( ! automatorwp_posts_matches( $event['post_id'], $trigger_options['post'] ) ) {
            return false;
        }

        switch ( $operation ) {
            case 'pass':
                // Don't deserve if user hasn't passed this quiz
                if( $event['status'] !== 'pass' ) {
                    return false;
                }
                break;
            case 'fail':
                // Don't deserve if user hasn't failed this quiz
                if( $event['status'] !== 'fail' ) {
                    return false;
                }
                break;
        }

        return $deserves_trigger;

    }

}

new AutomatorWP_LifterLMS_Complete_Assignment();