<?php
/**
 * Functions
 *
 * @package     AutomatorWP\Modern_Events_Calendar\Functions
 * @since       1.0.0
 */
// Exit if accessed directly
if( !defined( 'ABSPATH' ) ) exit;

/**
 * Options callback for select2 fields assigned to event tickets
 *
 * @since 1.0.0
 *
 * @param stdClass $field
 *
 * @return array
 */
function automatorwp_modern_events_calendar_options_cb_event_tickets( $field ) {

    $value = absint( $field->escaped_value );
    $options = array();

    // Bail if not ticket ID provided
    if( $value === 0 ) {
        return $options;
    }

    $event_id = absint( ct_get_object_meta( $field->object_id, 'event', true ) );

    // Bail if not event ID provided
    if( $event_id === 0 ) {
        return $options;
    }

    $tickets = get_post_meta( $event_id, 'mec_tickets', true );

    // Bail if event does not have tickets
    if ( empty( $tickets ) ) {
        return $options;
    }

    foreach ( $tickets as $ticket_id => $ticket ) {
        if( $value === absint( $ticket_id ) ) {
            $options[$value] = $ticket['name'];
        }
    }

    return $options;

}