<?php
/**
 * Booking Pending
 *
 * @package     AutomatorWP\Integrations\Modern_Events_Calendar\Triggers\Booking_Pending
 * @author      AutomatorWP <contact@automatorwp.com>, Ruben Garcia <rubengcdev@gmail.com>
 * @since       1.0.0
 */
// Exit if accessed directly
if( !defined( 'ABSPATH' ) ) exit;

class AutomatorWP_Modern_Events_Calendar_Booking_Pending extends AutomatorWP_Integration_Trigger {

    public $integration = 'modern_events_calendar';
    public $trigger = 'modern_events_calendar_booking_pending';

    /**
     * Register the trigger
     *
     * @since 1.0.0
     */
    public function register() {

        automatorwp_register_trigger( $this->trigger, array(
            'integration'       => $this->integration,
            'label'             => __( 'User booking for an event is pending', 'automatorwp-pro' ),
            'select_option'     => __( 'User booking for an event is <strong>pending</strong>', 'automatorwp-pro' ),
            /* translators: %1$s: Post title. %2$s: Number of times. */
            'edit_label'        => sprintf( __( 'User booking for %1$s is pending %2$s time(s)', 'automatorwp-pro' ), '{post}', '{times}' ),
            /* translators: %1$s: Post title. */
            'log_label'         => sprintf( __( 'User booking for %1$s is pending', 'automatorwp-pro' ), '{post}' ),
            'action'            => 'mec_booking_pended',
            'function'          => array( $this, 'listener' ),
            'priority'          => 10,
            'accepted_args'     => 1,
            'options'           => array(
                'post' => automatorwp_utilities_post_option( array(
                    'name' => __( 'Event:', 'automatorwp-pro' ),
                    'option_none_label' => __( 'any event', 'automatorwp-pro' ),
                    'post_type' => 'mec-events'
                ) ),
                'times' => automatorwp_utilities_times_option()
            ),
            'tags' => array_merge(
                automatorwp_utilities_post_tags( __( 'Event', 'automatorwp-pro' ) ),
                automatorwp_modern_events_calendar_event_tags(),
                automatorwp_utilities_times_tag()
            )
        ) );

    }

    /**
     * Trigger listener
     *
     * @since 1.0.0
     *
     * @param int $book_id ID of the booking
     */
    public function listener( $book_id ) {

        $event_id = absint( get_post_meta( $book_id, 'mec_event_id', true ) );
        $attendees = get_post_meta( $book_id, 'mec_attendees', true );

        foreach( $attendees as $attendee ) {

            $user = get_user_by( 'email', $attendee['email'] );

            // Skip if user not registered
            if( ! $user ) {
                continue;
            }

            automatorwp_trigger_event( array(
                'trigger' => $this->trigger,
                'post_id' => $event_id,
                'user_id' => $user->ID,
            ) );

        }

    }

}

new AutomatorWP_Modern_Events_Calendar_Booking_Pending();