<?php
/**
 * Tags
 *
 * @package     AutomatorWP\Paid_Memberships_Pro\Tags
 * @since       1.0.0
 */
// Exit if accessed directly
if( !defined( 'ABSPATH' ) ) exit;

/**
 * Membership tags
 *
 * @since 1.0.0
 *
 * @return array
 */
function automatorwp_paid_memberships_pro_get_membership_tags() {

    return array(
        'membership_id' => array(
            'label'     => __( 'Membership ID', 'automatorwp-pro' ),
            'type'      => 'integer',
            'preview'   => '1',
        ),
        'membership_name' => array(
            'label'     => __( 'Membership name', 'automatorwp-pro' ),
            'type'      => 'text',
            'preview'   => __( 'My membership', 'automatorwp-pro' ),
        ),
        'subscription_id' => array(
            'label'     => __( 'Subscription ID', 'automatorwp-pro' ),
            'type'      => 'integer',
            'preview'   => '1',
        ),
        'subscription_amount' => array(
            'label'     => __( 'Subscription amount', 'automatorwp-pro' ),
            'type'      => 'text',
            'preview'   => '123',
        ),
        'subscription_period' => array(
            'label'     => __( 'Subscription period', 'automatorwp-pro' ),
            'type'      => 'text',
            'preview'   => 'Year',
        ),
        'subscription_cycle' => array(
            'label'     => __( 'subscription cycle', 'automatorwp-pro' ),
            'type'      => 'text',
            'preview'   => 'The subscription cycle',
        ),
        'subscription_start' => array(
            'label'     => __( 'Subscription start date', 'automatorwp-pro' ),
            'type'      => 'text',
            'preview'   => '01/01/2024',
        ),
        'subscription_end' => array(
            'label'     => __( 'Subscription end date', 'automatorwp-pro' ),
            'type'      => 'text',
            'preview'   => '01/01/2025',
        ),
    );

}

/**
 * Custom trigger membership tag replacement
 *
 * @since 1.0.0
 *
 * @param string    $replacement    The tag replacement
 * @param string    $tag_name       The tag name (without "{}")
 * @param stdClass  $trigger        The trigger object
 * @param int       $user_id        The user ID
 * @param string    $content        The content to parse
 * @param stdClass  $log            The last trigger log object
 *
 * @return string
 */
function automatorwp_paid_memberships_pro_get_trigger_membership_tag_replacement( $replacement, $tag_name, $trigger, $user_id, $content, $log ) {


    $trigger_args = automatorwp_get_trigger( $trigger->type );

    // Skip if trigger is not from this integration
    if( $trigger_args['integration'] !== 'paid_memberships_pro' ) {
        return $replacement;
    }

    $membership_id = absint( automatorwp_get_log_meta( $log->id, 'membership_id', true ) );

    // Bail if not membership ID store
    if( $membership_id === 0 ) {
        return $replacement;
    }

    $membership_details = pmpro_getSpecificMembershipLevelForUser( $user_id, $membership_id );

    if( ! $membership_details ) {
        return $replacement;
    }

    switch( $tag_name ) {
        case 'membership_id':
            $replacement = $membership_id;
            break;
        case 'membership_name':
            $replacement = $membership_details->name;
            break;
        case 'subscription_id':
            $replacement = $membership_details->subscription_id;
            break;
        case 'subscription_amount':
            $replacement = $membership_details->billing_amount;
            break;
        case 'subscription_period':
            $replacement = $membership_details->cycle_period;
            break;
        case 'subscription_cycle':
            $replacement = $membership_details->cycle_number;
            break;
        case 'subscription_start':
            $replacement = ( ! empty( $membership_details->startdate ) ? date( 'Y-m-d', $membership_details->startdate ) : '' );
            break;
        case 'subscription_end':
            $replacement = ( ! empty( $membership_details->enddate ) ? date( 'Y-m-d', $membership_details->enddate ) : '' );
            break;
    }

    return $replacement;

}
add_filter( 'automatorwp_get_trigger_tag_replacement', 'automatorwp_paid_memberships_pro_get_trigger_membership_tag_replacement', 10, 6 );