<?php
/**
 * Accept Friend Request
 *
 * @package     AutomatorWP\Integrations\PeepSo\Triggers\Accept_Friend_Request
 * @author      AutomatorWP <contact@automatorwp.com>, Ruben Garcia <rubengcdev@gmail.com>
 * @since       1.0.0
 */
// Exit if accessed directly
if( !defined( 'ABSPATH' ) ) exit;

class AutomatorWP_PeepSo_Accept_Friend_Request extends AutomatorWP_Integration_Trigger {

    public $integration = 'peepso';
    public $trigger = 'peepso_accept_friend_request';

    /**
     * Register the trigger
     *
     * @since 1.0.0
     */
    public function register() {

        automatorwp_register_trigger( $this->trigger, array(
            'integration'       => $this->integration,
            'label'             => __( 'User accepts a friend request', 'automatorwp-pro' ),
            'select_option'     => __( 'User <strong>accepts</strong> a friend request', 'automatorwp-pro' ),
            /* translators: %1$s: Number of times. */
            'edit_label'        => sprintf( __( 'User accepts a friend request %1$s time(s)', 'automatorwp-pro' ), '{times}' ),
            'log_label'         => __( 'User accepts a friend request', 'automatorwp-pro' ),
            'action'            => 'peepso_friends_requests_after_accept',
            'function'          => array( $this, 'listener' ),
            'priority'          => 10,
            'accepted_args'     => 2,
            'options'           => array(
                'times' => automatorwp_utilities_times_option(),
            ),
            'tags' => array_merge(
                automatorwp_utilities_times_tag()
            )
        ) );

    }

    /**
     * Trigger listener
     *
     * @since 1.0.0
     *
     * @param int $from_user_id Form user ID
     * @param int $to_user_id   To user ID
     */
    public function listener( $from_user_id, $to_user_id ) {

        // Trigger accept friend request
        automatorwp_trigger_event( array(
            'trigger'           => $this->trigger,
            'user_id'           => $from_user_id,
            'to_user_id'        => $to_user_id,
        ) );

    }

}

new AutomatorWP_PeepSo_Accept_Friend_Request();