<?php
/**
 * React Comment
 *
 * @package     AutomatorWP\Integrations\PeepSo\Triggers\React_Comment
 * @author      AutomatorWP <contact@automatorwp.com>, Ruben Garcia <rubengcdev@gmail.com>
 * @since       1.0.0
 */
// Exit if accessed directly
if( !defined( 'ABSPATH' ) ) exit;

class AutomatorWP_PeepSo_React_Comment extends AutomatorWP_Integration_Trigger {

    public $integration = 'peepso';
    public $trigger = 'peepso_react_comment';

    /**
     * Register the trigger
     *
     * @since 1.0.0
     */
    public function register() {

        automatorwp_register_trigger( $this->trigger, array(
            'integration'       => $this->integration,
            'label'             => __( 'User reacts/unreacts an activity comment', 'automatorwp-pro' ),
            'select_option'     => __( 'User reacts/unreacts an <strong>activity comment</strong>', 'automatorwp-pro' ),
            /* translators: %1$s: Operation (reacts or unreacts). %2$s: Number of times. */
            'edit_label'        => sprintf( __( 'User %1$s an activity comment %2$s time(s)', 'automatorwp-pro' ), '{operation}', '{times}' ),
            /* translators: %1$s: Operation (reacts or unreacts). */
            'log_label'         => sprintf( __( 'User %1$s an activity comment', 'automatorwp-pro' ), '{operation}' ),
            'action'            => array(
                'peepso_action_react_add',
                'peepso_action_react_remove',
            ),
            'function'          => array( $this, 'listener' ),
            'priority'          => 10,
            'accepted_args'     => 1,
            'options'           => array(
                'operation' => array(
                    'from' => 'operation',
                    'fields' => array(
                        'operation' => array(
                            'name' => __( 'Operation:', 'automatorwp-pro' ),
                            'type' => 'select',
                            'options' => array(
                                'react'       => __( 'reacts', 'automatorwp-pro' ),
                                'unreact'    => __( 'unreacts', 'automatorwp-pro' ),
                            ),
                            'default' => 'react'
                        ),
                    )
                ),
                'times' => automatorwp_utilities_times_option(),
            ),
            'tags' => array_merge(
                automatorwp_utilities_times_tag()
            )
        ) );

    }

    /**
     * Trigger listener
     *
     * @since 1.0.0
     *
     * @param stdClass $data
     */
    public function listener( $data ) {

        $action = ( current_filter() === 'peepso_action_react_add' ? 'react' : 'unreact' );

        $user_id = $data->react_user_id;     // id of user adding the react
        $post_id = $data->react_external_id; // id of item being reactd; i.e. post_id
        $module_id = $data->react_module_id; // Defines from which module happens the react (0 from user profile, 1 from activity post or comment, etc)

        if( ! in_array( $module_id, array( 1, 4, 5 ) )  ) {
            return;
        }

        $post_type = get_post_type( $post_id );

        if( $post_type !== 'peepso-comment' ) {
            return;
        }

        // Trigger reacts
        automatorwp_trigger_event( array(
            'trigger'           => $this->trigger,
            'user_id'           => $user_id,
            'post_id'           => $post_id,
            'action'            => $action,
        ) );

    }

    /**
     * User deserves check
     *
     * @since 1.0.0
     *
     * @param bool      $deserves_trigger   True if user deserves trigger, false otherwise
     * @param stdClass  $trigger            The trigger object
     * @param int       $user_id            The user ID
     * @param array     $event              Event information
     * @param array     $trigger_options    The trigger's stored options
     * @param stdClass  $automation         The trigger's automation object
     *
     * @return bool                          True if user deserves trigger, false otherwise
     */
    public function user_deserves_trigger( $deserves_trigger, $trigger, $user_id, $event, $trigger_options, $automation ) {

        // Don't deserve if post is not received
        if( ! isset( $event['action'] ) ) {
            return false;
        }

        // Don't deserve if action doesn't match with the trigger option
        if( $trigger_options['operation'] !== $event['action'] ) {
            return false;
        }

        return $deserves_trigger;

    }

}

new AutomatorWP_PeepSo_React_Comment();