(function( $ ) {

    // On change set colors
    $('body').on('change', '.automatorwp-action-qr-code-generate .cmb2-id-qr-set-colors input', function(e) {
        var row = $(this).closest('.cmb-row');
        var foreground_color_2_row = row.siblings('.cmb2-id-qr-foreground-color-2');

        var set_colors = $(this).val();
        var first_change = row.hasClass('is-option-change');

        if( set_colors === 'single' || set_colors === '' ) {
            // Hide the foreground color 2 input
            if( first_change ) {
                foreground_color_2_row.hide();
            } else {
                foreground_color_2_row.slideUp('fast');
            }
        } else {
            // Show the foreground color 2 input
            if( first_change ) {
                foreground_color_2_row.show();
            } else {
                foreground_color_2_row.slideDown('fast');
            }
        }

        row.removeClass('is-option-change');
    });

    // On change eye colors
    $('body').on('change', '.automatorwp-action-qr-code-generate .cmb2-id-qr-eye-colors input', function(e) {
        var row = $(this).closest('.cmb-row');
        var eye_color_1_row = row.siblings('.cmb2-id-qr-foreground-eye-color-1');
        var eye_color_2_row = row.siblings('.cmb2-id-qr-foreground-eye-color-2');

        var first_change = row.hasClass('is-option-change');

        if( ! $(this).is(':checked') ) {
            // Hide the foreground color 2 input
            if( first_change ) {
                eye_color_1_row.hide();
                eye_color_2_row.hide();
            } else {
                eye_color_1_row.slideUp('fast');
                eye_color_2_row.slideUp('fast');
            }
        } else {
            // Show the foreground color 2 input
            if( first_change ) {
                eye_color_1_row.show();
                eye_color_2_row.show();
            } else {
                eye_color_1_row.slideDown('fast');
                eye_color_2_row.slideDown('fast');
            }
        }

        row.removeClass('is-option-change');
    });

    // On click on an option, check if form contains the set colors and eye colors inputs
    $('body').on('click', '.automatorwp-action-qr-code-generate  .automatorwp-option', function(e) {

        var item = $(this).closest('.automatorwp-automation-item');
        var option = $(this).data('option');
        var option_form = item.find('.automatorwp-option-form-container[data-option="' + option + '"]');


        var set_colors_row = option_form.find('.cmb2-id-qr-set-colors');

        if( set_colors_row !== undefined ) {
            set_colors_row.addClass('is-option-change');
            set_colors_row.find('input[checked="checked"]').trigger('change');
        }

        var eye_colors_row = option_form.find('.cmb2-id-qr-eye-colors');

        if( eye_colors_row !== undefined ) {
            eye_colors_row.addClass('is-option-change');

            eye_colors_row.find('input').trigger('change');
        }

    });

})( jQuery );