<?php
/**
 * Tags
 *
 * @package     AutomatorWP\QR_Code\Tags
 * @since       1.0.0
 */
// Exit if accessed directly
if( !defined( 'ABSPATH' ) ) exit;

/**
 * QR code tags
 *
 * @since 1.0.0
 *
 * @return array
 */
function automatorwp_qr_code_get_actions_qr_code_tags() {

    return array(
        'qr_code_url' => array(
            'label'     => __( 'QR code URL', 'automatorwp-pro' ),
            'type'      => 'text',
            'preview'   => 'https://yourdomain.com/wp-content/uploads/automatorwp-qr-code/automatorwp_qr_code_6694be796f7ba9.31596445.png',
        ),
        'qr_code_image' => array(
            'label'     => __( 'QR code image', 'automatorwp-pro' ),
            'type'      => 'text',
            'preview'   => '<img src="https://yourdomain.com/sandbox/wp-content/uploads/automatorwp-qr-code/automatorwp_qr_code_6694be796f7ba9.31596445.png" />',
        ),
    );

}

/**
 * Custom action QR code tag replacement
 *
 * @since 1.0.0
 *
 * @param string    $replacement    The tag replacement
 * @param string    $tag_name       The tag name (without "{}")
 * @param stdClass  $action         The action object
 * @param int       $user_id        The user ID
 * @param string    $content        The content to parse
 * @param stdClass  $log            The last action log object
 *
 * @return string
 */
function automatorwp_qr_code_get_qr_code_tag_replacement( $replacement, $tag_name, $action, $user_id, $content, $log ) {


    $action_args = automatorwp_get_action( $action->type );

    // Skip if action is not from this integration
    if( $action_args['integration'] !== 'qr_code' ) {
        return $replacement;
    }

    switch( $tag_name ) {
        case 'qr_code_url':
            $replacement = automatorwp_get_log_meta( $log->id, 'qr_code_url', true );
            break;
        case 'qr_code_image':
            $replacement = automatorwp_get_log_meta( $log->id, 'qr_code_image', true );
            break;
    }

    return $replacement;

}
add_filter( 'automatorwp_get_action_tag_replacement', 'automatorwp_qr_code_get_qr_code_tag_replacement', 10, 6 );
