<?php
/**
 * Remove Membership
 *
 * @package     AutomatorWP\Integrations\Restrict_Content_Pro\Actions\Remove_Membership
 * @author      AutomatorWP <contact@automatorwp.com>, Ruben Garcia <rubengcdev@gmail.com>
 * @since       1.0.0
 */
// Exit if accessed directly
if( !defined( 'ABSPATH' ) ) exit;

class AutomatorWP_Restrict_Content_Pro_Remove_Membership extends AutomatorWP_Integration_Action {

    public $integration = 'restrict_content_pro';
    public $action = 'restrict_content_pro_remove_membership';

    /**
     * Register the trigger
     *
     * @since 1.0.0
     */
    public function register() {

        automatorwp_register_action( $this->action, array(
            'integration'       => $this->integration,
            'label'             => __( 'Remove user from membership level', 'automatorwp-pro' ),
            'select_option'     => __( 'Remove user from <strong>membership level</strong>', 'automatorwp-pro' ),
            /* translators: %1$s: Membership. */
            'edit_label'        => sprintf( __( 'Remove user from %1$s', 'automatorwp-pro' ), '{membership}' ),
            /* translators: %1$s: Membership. */
            'log_label'         => sprintf( __( 'Remove user from %1$s', 'automatorwp-pro' ), '{membership}' ),
            'options'           => array(
                'membership' => automatorwp_utilities_ajax_selector_option( array(
                    'field'             => 'membership',
                    'name'              => __( 'Membership Level:', 'automatorwp-pro' ),
                    'option_default'    => __( 'a membership level', 'automatorwp-pro' ),
                    'option_none_value' => 'any',
                    'option_none_label' => __( 'all membership levels', 'automatorwp-pro' ),
                    'option_custom'         => true,
                    'option_custom_desc'   => __( 'Membership level ID', 'automatorwp-pro' ),
                    'action_cb'         => 'automatorwp_restrict_content_pro_get_memberships',
                    'options_cb'        => 'automatorwp_restrict_content_pro_options_cb_membership',
                    'default'           => 'any'
                ) ),
            ),
        ) );

    }

    /**
     * Action execution function
     *
     * @since 1.0.0
     *
     * @param stdClass  $action             The action object
     * @param int       $user_id            The user ID
     * @param array     $action_options     The action's stored options (with tags already passed)
     * @param stdClass  $automation         The action's automation object
     */
    public function execute( $action, $user_id, $action_options, $automation ) {

        // Shorthand
        $level_id = $action_options['membership'];

        $customer = rcp_get_customer_by_user_id( $user_id );

        // Bail if user is not a customer
        if ( ! $customer ) {
            return;
        }

        if( $level_id === 'any' ){
            // Remove from all memberships
            rcp_disable_customer_memberships( $customer->get_id() );
        } else {
            $args = array(
                'customer_id' => absint( $customer->get_id() ),
                'object_id'   => $level_id,
                'number'      => 1,
            );

            $user_memberships = rcp_get_memberships( $args );

            // Bail if user has not this membership
            if ( empty( $user_memberships ) ) {
                return;
            }

            if ( ! isset( $user_memberships[0] ) ) {
                return;
            }

            // Remove from specific membership
            $user_memberships[0]->disable();
        }

    }

}

new AutomatorWP_Restrict_Content_Pro_Remove_Membership();